package com.pcloud.book.copyright.facade.impl;

import com.pcloud.book.copyright.biz.BookAuthCodeBiz;
import com.pcloud.book.copyright.facade.BookAuthCodeFacade;
import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;
import com.pcloud.book.copyright.vo.CodeUseStatusVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2018/11/29 16:59
 */
@RequestMapping("bookAuthCode")
@RestController("bookAuthCodeFacade")
public class BookAuthCodeFacadeImpl implements BookAuthCodeFacade {

    @Autowired
    private BookAuthCodeBiz bookAuthCodeBiz;

    @Override
    @RequestMapping(value = "checkCode", method = RequestMethod.POST)
    public ResponseDto<CodeUseStatusVO> checkCode(@CookieValue("userInfo") String userInfo, @RequestBody CheckCodeParam checkCodeParam) throws PermissionException, BizException {
        Long channelId = checkCodeParam.getChannelId();
        if(channelId == null){
            channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Integer codeUseStatus = bookAuthCodeBiz.checkCode(checkCodeParam, channelId, wechatUserId);
        CodeUseStatusVO codeUseStatusVO = new CodeUseStatusVO();
        codeUseStatusVO.setCodeUseStatus(codeUseStatus);
        return new ResponseDto<>(codeUseStatusVO);
    }

    @Override
    @PostMapping("checkServe")
    public ResponseDto<Boolean> checkServe(@CookieValue("userInfo") String userInfo, @RequestBody CheckIsAuthServeParam checkIsAuthServeParam) throws PermissionException, BizException {
        Long channelId = checkIsAuthServeParam.getChannelId();
        if(channelId == null){
            channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Boolean code = bookAuthCodeBiz.checkServe(checkIsAuthServeParam, channelId, wechatUserId);
        return new ResponseDto<>(code == null ? false : code);
    }
}
