package com.pcloud.book.group.biz;

import java.util.Map;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.exceptions.BizException;

/**
 * Description 社群书群二维码业务逻辑层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupBiz {

    /**
     * 创建社群书时生成群二维码
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    BookGroup createBookGroupAfterCreateBook(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo(Long bookGroupId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfoByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 更新群二维码信息
     * @param bookGroup 群二维码实体
     * @throws BizException
     */
    void updateBookGroup(BookGroup bookGroup) throws BizException;

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void deleteByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void recoverByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据社群码ID获取书名
     * @param bookGroupId 社群码ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getBookNameByBookGroupId(Long bookGroupId) throws BizException;
}
