package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 社群书群二维码数据访问层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupDao extends BaseDao<BookGroup> {

    /**
     * 获取DTO信息
     * @param bookGroupId 群二维码ID
     * @return
     */
    BookGroupDTO getDTOById(Long bookGroupId);

    /**
     * 获取DTO信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long deleteByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long recoverByBookId(Long bookId, Long channelId, Long adviserId);
}
