package com.pcloud.book.group.dao.impl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Repository;
import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 社群书群二维码数据访问层接口实现类
 * Created by PENG on 2019/4/17.
 */
@Repository("bookGroupDao")
public class BookGroupDaoImpl extends BaseDaoImpl<BookGroup> implements BookGroupDao {

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOById(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), bookGroupId);
    }

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().selectOne(getStatement("getDTOByBookId"), paramMap);
    }

    /**
     * 根据书刊ID删除
     */
    @Override
    public long deleteByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("deleteByBookId"), paramMap);
    }

    /**
     * 根据书刊ID恢复
     */
    @Override
    public long recoverByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("recoverByBookId"), paramMap);
    }
}
