package com.pcloud.book.group.facade;

import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * Description 社群书群二维码接口
 * Created by PENG on 2019/4/17.
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupFacadeCloud", path = "bookGroup")
@Api(description = "社群书群二维码接口")
public interface BookGroupFacade {

    /**
     * 获取社群书群二维码信息
     * @param token       用户身份信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "群二维码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfo(@RequestHeader("token") String token, @RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取社群书群二维码信息
     * @param token     用户身份信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书刊ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfoByBookId", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfoByBookId(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId) throws BizException, PermissionException, JsonParseException;

    /**
     * 更新群二维码信息
     * @param token     用户身份信息
     * @param bookGroup 群二维码实体
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "更新群二维码信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroup", value = "群二维码实体", dataType = "BookGroup", paramType = "body")
    })
    @RequestMapping(value = "updateBookGroup", method = RequestMethod.POST)
    ResponseDto<?> updateBookGroup(@RequestHeader("token") String token, @RequestBody BookGroup bookGroup)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 根据社群码ID获取书名
     * @param bookGroupId 社群码ID
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "根据社群码ID获取书名", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "社群码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookNameByBookGroupId", method = RequestMethod.GET)
    ResponseDto<?> getBookNameByBookGroupId(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;
}
