package com.pcloud.book.group.facade.impl;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.facade.BookGroupFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

/**
 * Description 社群书群二维码接口实现类
 * Created by PENG on 2019/4/17.
 */
@RestController("bookGroupFacade")
@RequestMapping("bookGroup")
public class BookGroupFacadeImpl implements BookGroupFacade {

    @Autowired
    private BookGroupBiz bookGroupBiz;

    /**
     * 获取社群书群二维码信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    public ResponseDto<?> getBookGroupInfo(@RequestHeader("token") String token, @RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException {
        if (null == bookGroupId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
        }
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookGroupBiz.getBookGroupInfo(bookGroupId));
    }

    /**
     * 获取社群书群二维码信息
     */
    @Override
    @RequestMapping(value = "getBookGroupInfoByBookId", method = RequestMethod.GET)
    public ResponseDto<?> getBookGroupInfoByBookId(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId) throws BizException, PermissionException, JsonParseException {
        if (null == bookId || null == channelId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
        }
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(bookGroupBiz.getBookGroupInfoByBookId(bookId, channelId, adviserId));
    }

    /**
     * 更新群二维码信息
     */
    @Override
    @RequestMapping(value = "updateBookGroup", method = RequestMethod.POST)
    public ResponseDto<?> updateBookGroup(@RequestHeader("token") String token, @RequestBody BookGroup bookGroup)
            throws BizException, PermissionException, JsonParseException {
        if (null == bookGroup) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
        }
        bookGroupBiz.updateBookGroup(bookGroup);
        return new ResponseDto<>();
    }

    /**
     * 根据社群码ID获取书名
     */
    @Override
    @RequestMapping(value = "getBookNameByBookGroupId", method = RequestMethod.GET)
    public ResponseDto<?> getBookNameByBookGroupId(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException {
        if (null == bookGroupId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数有误！");
        }
        return new ResponseDto<>(bookGroupBiz.getBookNameByBookGroupId(bookGroupId));
    }
}
