package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletTrackDTO;
import com.pcloud.book.applet.dto.ReadBookRecordDTO;
import com.pcloud.book.applet.entity.AppletRecord;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * (AppletRecord)表服务接口
 *
 * @author makejava
 * @since 2020-08-27 15:49:57
 */
public interface AppletRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletRecord getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletRecord 实例对象
     * @return 主键
     */
    Long insert(AppletRecord appletRecord);

    /**
     * 修改数据
     *
     * @param appletRecord 实例对象
     */
    void update(AppletRecord appletRecord);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取足迹列表
     * @param wechatUserId
     * @param date
     * @param recordTypes
     * @param queryName
     * @param currentPage
     * @param numPerPage
     * @param typeName
     * @return
     */
    PageBeanNew<AppletRecordDTO> listAppletRecord(Long wechatUserId, String date, List<Integer> recordTypes, String queryName, Integer currentPage, Integer numPerPage, String typeName, Long officialAccountsId);

    List<String> listUnreachableDate(Long wechatUserId);

    /**
     * 从足迹获取应用或作品浏览人数
     * @param recordType
     * @param serveIds
     * @return
     */
    Map<Long, AppletAppOrProductDTO> getAppOrProductBrowseCount(Integer recordType, List<Long> serveIds);

    void fillAppletRecord(List<AppletRecordDTO> recordList, Integer bookType, Long wechatUserId);

    Object handleAppletRecordTypeCode(Long lastAppletRecordId);

    void stopHandleAppletRecordTypeCode();

    /**
     * 获取足迹目录
     * @param wechatUserId
     * @param date
     * @return
     */
    List<AppletRecordDTO> getAppletRecordCatalogue(Long wechatUserId, String date, Long officialAccountsId);

    /**
     * 手动处理应用作品和资讯的typeCode
     */
    void HandleTypeCode();

    /**
     * 新增用户阅读记录
     * @param readBookRecordDTO
     */
    void addReadBookRecord(ReadBookRecordDTO readBookRecordDTO);

    /**
     * 小程序我的足迹埋点
     * @param wechatUserId 用户ID
     * @param fromType 数据来源 0内容筛选 1指定按钮
     * @param typeName 名称
     * @param recordTypes 类型
     */
    void addFootstep(Long wechatUserId, Integer fromType, String typeName, List<Integer> recordTypes);

    /**
     * 小程序埋点
     *
     * @param wechatUserId       用户ID
     * @param officialAccountsId officialAccountsId
     * @param trackDTO           埋点信息
     */
    void track(Long wechatUserId, Long officialAccountsId, AppletTrackDTO trackDTO);

    /**
     * 最近一条足迹
     * @author：zhuyajie
     * @date：2021/8/4 10:42
     *  * @param null
     */
    AppletRecordDTO getLatestAppletRecord(Long wechatUserId, Long officialAccountsId);
}
