package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.entity.AppletSubscribeSend;
import com.pcloud.book.applet.biz.AppletSubscribeSendBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * (AppletSubscribeSend)表控制层
 *
 * @author wubo 
 * @since 2022-05-24 15:59:27
 */
@RestController("appletSubscribeSendFacade")
@RequestMapping("appletSubscribeSend")
public class AppletSubscribeSendFacade {
    
    @Autowired
    private AppletSubscribeSendBiz appletSubscribeSendBiz;

    
    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo,
                                  @RequestParam Long id) throws BizException, PermissionException {
           Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeSendBiz.getById(id));
    }
    
    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) 
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeSendBiz.getList(currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, 
                                 @RequestBody AppletSubscribeSend appletSubscribeSend)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeSendBiz.insert(appletSubscribeSend));
    }
    
    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo, 
                                 @RequestBody AppletSubscribeSend appletSubscribeSend) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletSubscribeSendBiz.update(appletSubscribeSend);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo, 
                                     @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeSendBiz.deleteById(id);
        return new ResponseDto<>();
    }
    
    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@CookieValue("userInfo") String userInfo, 
                                         @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeSendBiz.softDeleteById(id);
        return new ResponseDto<>();
    }



}
