package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.BookUserBrowseRecord;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * 书籍用户关联表(BookUserBrowseRecord)表服务接口
 *
 * @author wubo
 * @since 2021-12-03 10:40:19
 */
public interface BookUserBrowseRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param bookId 主键
     * @return 实例对象
     */
    BookUserBrowseRecord getById(Long bookId);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param bookUserBrowseRecord 实例对象
     * @return 主键
     */
    Long insert(BookUserBrowseRecord bookUserBrowseRecord);

    /**
     * 修改数据
     *
     * @param bookUserBrowseRecord 实例对象
     */
    void update(BookUserBrowseRecord bookUserBrowseRecord);

    /**
     * 通过主键删除数据
     *
     * @param bookId 主键
     * @return 是否成功
     */
    void deleteById(Long bookId);

    /**
     * 通过主键软删除数据
     *
     * @param bookId 主键
     * @return 是否成功
     */
    void softDeleteById(Long bookId);

    /**
     * 根据书籍id获取用户id
     * @param bookIds
     * @return
     */
    List<Long> getUserIdsByBookId(List<Long> bookIds);
}
