package com.pcloud.book.consumer.function;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.function.douluo.dto.AppTaskDTO;
import com.pcloud.function.douluo.dto.DlBookDTO;
import com.pcloud.function.douluo.service.DlAppTaskService;
import com.pcloud.function.douluo.service.DlBookService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class FunctionConsr {

    @Autowired
    private DlBookService dlBookService;
    @Autowired
    private DlAppTaskService dlAppTaskService;

    /**
     根据bookId判断是否斗罗书
     */
    public Boolean checkIsDlBook(Long bookId){
        Boolean isDlBook = false;
        if (null == bookId) {
            return isDlBook;
        }
        try {
            isDlBook = ResponseHandleUtil.parseResponse(dlBookService.checkIsDlBook(bookId), Boolean.class);
        } catch (Exception e) {
            log.error("function.dlBookService.checkIsDlBook远程调用失败");
        }
        return isDlBook;
    }

    public List<AppTaskDTO> getAppTaskList() {
        List<AppTaskDTO> appTaskList = new ArrayList<>();
        try {
            appTaskList = ResponseHandleUtil.parseListResponse(dlAppTaskService.getAppTaskList(), AppTaskDTO.class);
        } catch (Exception e) {
            log.error("function.dlAppTaskService.getAppTaskList()远程调用失败");
        }
        return appTaskList;
    }

    public DlBookDTO getDlBookInfo(Long bookId) {
        log.info("function.dlAppTaskService.getDlBookInfo()获取斗罗书信息");
        DlBookDTO dlBookDTO = null;
        if (null == bookId) {
            return dlBookDTO;
        }
        try {
            dlBookDTO = ResponseHandleUtil.parseResponse(dlBookService.getDlBookInfo(bookId), DlBookDTO.class);
        } catch (Exception e) {
            log.error("function.dlAppTaskService.getDlBookInfo()远程调用失败");
        }
        return dlBookDTO;
    }

    public List<Long> getAllDlBookId() {
        log.info("function.dlAppTaskService.getAllDlBookId()获取所有斗罗书信息");
        List<Long> allBookIds = new ArrayList<>();
        try {
            allBookIds = ResponseHandleUtil.parseListResponse( dlBookService.getAllDlBookId(), Long.class);
        } catch (Exception e) {
            log.error("function.dlAppTaskService.getAllDlBookId()远程调用失败");
        }
        return allBookIds;
    }
}

