package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.dto.SceneAuthCodeResponseDTO;
import com.pcloud.book.copyright.entity.BookSceneAuthCode;
import com.pcloud.book.copyright.dao.BookSceneAuthCodeDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 书籍二维码授权码记录表(BookSceneAuthCode)表数据库访问层
 *
 * @author makejava
 * @since 2021-10-19 14:14:47
 */
@Repository("bookSceneAuthCodeDaoImpl")
public class BookSceneAuthCodeDaoImpl extends BaseDaoImpl<BookSceneAuthCode> implements BookSceneAuthCodeDao {

    @Override
    public Integer getMaxBatchNum(Long bookId, Long channelId, Long sceneId, Long adviserId, Integer authBookType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("sceneId",sceneId);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getMaxBatchNum"), paramMap);
    }

    @Override
    public void deleteSceneAuthCode(List<Long> ids) {
        this.getSqlSession().delete(this.getStatement("deleteSceneAuthCode"), ids);
    }

    @Override
    public List<Long> getCodeIdList(Long bookId, Long channelId, Long adviserId, String keyWord, Integer authBookType, Long sceneId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);
        paramMap.put("keyword",keyWord);
        paramMap.put("sceneId",sceneId);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
        } else {
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectList(this.getStatement("getCodeIdList"), paramMap);
    }

    @Override
    public BookSceneAuthCode getByCode(String code) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("code",code);
        return this.getSqlSession().selectOne(this.getStatement("getByCode"), paramMap);
    }

    @Override
    public void updateUseCount(Long id) {
        this.getSqlSession().update(this.getStatement("updateUseCount"), id);
    }

    @Override
    public List<SceneAuthCodeResponseDTO> getCodeCount(Long bookId, List<Long> sceneIds) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("sceneIds",sceneIds);
        return this.getSqlSession().selectList(this.getStatement("getCodeCount"), paramMap);
    }

    @Override
    public void batchUpdate(List<BookSceneAuthCode> list) {
        this.getSqlSession().update(this.getStatement("batchUpdate"), list);
    }

    @Override
    public List<BookAuthCodeDTO> getBookSceneAuthCodeList(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("getBookSceneAuthCodeList"), paramMap);
    }
}