package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.copyright.entity.BookSceneAuth;
import com.pcloud.book.copyright.dao.BookSceneAuthDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 书籍二维码授权表(BookSceneAuth)表数据库访问层
 *
 * @author makejava
 * @since 2021-10-19 14:14:22
 */
@Repository("bookSceneAuthDaoImpl")
public class BookSceneAuthDaoImpl extends BaseDaoImpl<BookSceneAuth> implements BookSceneAuthDao {

    @Override
    public BookSceneAuth getAuthSceneInfo(Long bookId, Long sceneId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("sceneId",sceneId);
        return this.getSqlSession().selectOne(this.getStatement("getAuthSceneInfo"), paramMap);
    }

    @Override
    public List<BookSceneAuth> getAuthSceneIds(Long bookId, List<Long> sceneIds) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("sceneIds",sceneIds);
        return this.getSqlSession().selectList(this.getStatement("getAuthSceneIds"), paramMap);
    }

    @Override
    public void batchUpdate(List<BookSceneAuth> list) {
        this.getSqlSession().update(this.getStatement("batchUpdate"), list);
    }
}