package com.pcloud.book.group.biz;

import com.pcloud.book.group.entity.ResourcePageBookstore;
import com.pcloud.book.group.enums.ResourcePageFixtureTypeEnum;
import com.pcloud.book.group.vo.ResourcePageBookstoreVO;
import com.pcloud.common.page.PageBeanNew;
import java.util.List;

/**
 * 实体书购买(ResourcePageBookstore)表服务接口
 *
 * @author makejava
 * @since 2021-08-16 14:40:27
 */
public interface ResourcePageBookstoreBiz {

    /**
     * 通过ID查询单条数据
     */
    ResourcePageBookstore getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     */
    Long insert(ResourcePageBookstore resourcePageBookstore);
    
    /**
     * 新增数据
     */
    void insert(List<ResourcePageBookstore> list);

    /**
     * 修改数据
     */
    void update(ResourcePageBookstore resourcePageBookstore);

    /**
     * 通过主键删除数据
     */
    void deleteById(Long id);

    void deleteByResourcePageId(Long resourcePageId, Integer fixtureType);

    List<ResourcePageBookstoreVO> getByResourcePageId(Long resourcePageId, Long channelId, Long wechatUserId, ResourcePageFixtureTypeEnum fixtureTypeEnum);
}
