package com.pcloud.book.group.biz.impl;

import com.pcloud.book.group.entity.WeworkTeacherFriendRecord;
import com.pcloud.book.group.dao.WeworkTeacherFriendRecordDao;
import com.pcloud.book.group.biz.WeworkTeacherFriendRecordBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * 点击加老师好友记录表(WeworkTeacherFriendRecord)表服务实现类
 *
 * @author makejava
 * @since 2020-12-25 20:01:43
 */
@Service("weworkTeacherFriendRecordBiz")
public class WeworkTeacherFriendRecordBizImpl implements WeworkTeacherFriendRecordBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeworkTeacherFriendRecordBizImpl.class);

    @Autowired
    private WeworkTeacherFriendRecordDao weworkTeacherFriendRecordDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public WeworkTeacherFriendRecord getById(Long id) {
        return weworkTeacherFriendRecordDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = weworkTeacherFriendRecordDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(WeworkTeacherFriendRecord weworkTeacherFriendRecord) {
        weworkTeacherFriendRecordDao.insert(weworkTeacherFriendRecord);
        return weworkTeacherFriendRecord.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(WeworkTeacherFriendRecord weworkTeacherFriendRecord) {
        if(weworkTeacherFriendRecord == null || !NumberUtil.isNumber(weworkTeacherFriendRecord.getId())){
            throw BizException.PARAM_IS_NULL;
        }
        weworkTeacherFriendRecordDao.update(weworkTeacherFriendRecord);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        weworkTeacherFriendRecordDao.deleteById(id);
    }
}