package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 图书标准服务(ResourcePageModel)实体类
 *
 * @author 
 * @since 2022-01-15 15:16:45
 */
@Data
public class ResourcePageModel extends BaseEntity {
    private static final long serialVersionUID = -99572890424146893L;
    /**
     * 主键
     */
    private Long id;
    /**
     * h5页id
     */
    private Long resourcePageId;
    /**
     * 资源标题
     */
    private String serveTitle;
    /**
     * 资源图标
     */
    private String serveIcon;
    /**
     * 资源id
     */
    private Long serveId;
    /**
     * 资源类型
     */
    private String serveType;
    /**
     * 链接url
     */
    private String linkUrl;
    /**
     * 资源类型
     */
    private String typeCode;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 是否自定义
     **/
    private Integer selfSet;

    @ApiModelProperty("应用或作品类型名称")
    private String typeName;

    @ApiModelProperty("是否第三方链接")
    private Boolean hasThirdLink;

    @ApiModelProperty("跳转结果链接")
    private String resultUrl;


    @ApiModelProperty("是否配置了公众号工具")
    private Boolean hasOfficialAccountsTool;


    /**
     * 资源名称
     */
    private String serveName;
    /**
     * 资源封面
     */
    private String servePic;
}

