package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.UserLastBookReDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * 小程序用户书架
 */
public interface AppletUserBookcaseBiz {

    /**
     * 添加图书到书架
     * @param appletUserBookcase
     */
    void addUserBook(AppletUserBookcase appletUserBookcase);

    /**
     * 查用户书架列表
     * @param wechatUserId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletUserBookcaseDTO> listByWechatUserId(Long wechatUserId, Integer currentPage, Integer numPerPage);

    /**
     * 新增用户资源点击记录
     * @param appletUserClickRecord
     */
    void addUserClickRecord(AppletUserClickRecord appletUserClickRecord);

    /**
     * 用户图书资源点击统计
     * @param wechatUserId
     * @param bookId
     * @return
     */
    Map<String,Object> getUserClickStatistic(Long wechatUserId, Long bookId, Long channelId, Long adviserId);


    UserLastBookReDTO getUserLastBookRe(Long wechatUserId);

    /**
     * 批量删除
     * @author：zhuyajie
     * @date：2020/5/11 16:06
     *  * @param null
     */
    void deleteByIds(List<Long> ids, Long wechatUserId);

    /**
     * 更新读者关于本书的阅读方式
     * @param appletUserBookcase
     */
    void updateUserReadType(AppletUserBookcase appletUserBookcase);

    /**
     * 获取读者关于本书的阅读方式
     * @param wechatUserId
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    AppletUserBookcase getUserReadType(Long wechatUserId, Long bookId, Long adviserId, Long channelId);

    /**
     * 已读书刊随机换一本书展示
     * @author：zhuyajie
     * @date：2020/5/15 14:49
     *  * @param null
     */
    void randomChangeBook(Long wechatUserId);
}
