package com.pcloud.book.mq.topic;


import com.pcloud.appcenter.app.entity.App;
import com.pcloud.appcenter.base.enums.AppEnum;
import com.pcloud.book.clock.dao.BookClockInfoDao;
import com.pcloud.book.keywords.dao.BookGuideReplyDao;
import com.pcloud.book.keywords.dao.KeywordDao;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2019/6/6 11:10
 */
@Component
@RabbitListener(queues = MQTopicConumer.APP_UPDATE)
public class AppUpdateListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpdateListener.class);

    @Autowired
    private KeywordDao keywordDao;

    @Autowired
    private BookGuideReplyDao bookGuideReplyDao;

    @Autowired
    private BookClockInfoDao bookClockInfoDao;
    /**
     * 接收消息
     */
    @RabbitHandler
    @ParamLog("应用修改消息监听")
    public void onMessage(App app) {
        if (null == app) {
            return;
        }
        try {
            if(AppEnum.AUDIT_STATE_PASS.value.equals(app.getAuditState())){
                keywordDao.updateServeInfo(app.getAppId(), "APP", app.getTitle(), app.getSquareImg());
                bookGuideReplyDao.updateServeInfo(app.getAppId(), "APP", app.getTitle(), app.getSquareImg());
                bookClockInfoDao.updateAppInfo(app.getAppId(),app.getTitle(),app.getSquareImg());
            }
        } catch (Exception e) {
            LOGGER.error("应用修改消息监听消费topic,<ERROR>:" + e.getMessage(), e);
            return;
        }
    }

}
