package com.pcloud.book.rightsSetting.dao;

import com.pcloud.book.rightsSetting.dto.ReadTypeCountDTO;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.common.core.dao.BaseDao;

import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 每周/长期权益(RightsSettingItem)表数据库访问层
 *
 * @author zhuyajie
 * @since 2020-04-19 17:11:38
 */
public interface RightsSettingItemDao extends BaseDao<RightsSettingItem>{


    /**
     * 通过实体作为筛选条件查询
     *
     * @param rightsSettingItem 实例对象
     * @return 对象列表
     */
    List<RightsSettingItem> queryAll(RightsSettingItem rightsSettingItem);

    /**
     * 通过权益主键删除数据
     *
     * @param rightsSettingId 权益主键
     * @return 影响行数
     */
    int deleteByRightsSettingId(Long rightsSettingId, String rightsType);

    /**
     * 查所有权益分类
     * @param rightsType
     * @return
     */
    List<RightsSettingClassify>getAllRightsClassify(String rightsType);

    List<RightsSettingItem> getItemByRightsIdAndType(Long rightsSettingId, String rightsType);

    List<RightsSettingItem> getItemsByRightsSettingId4Read(Long rightsSettingId, String rightsType);

    ReadTypeCountDTO getCount4Item(Long rightsSettingId);
}