package com.pcloud.book.group.constant;

import com.pcloud.book.group.dto.AutoUpdateGroupNumDTO;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * book业务常量类
 */
public class BookBusinessConstants {

    /**
     * 需更新微信群信息
     */
    public static final Map<String, AutoUpdateGroupNumDTO> GROUP_NUM_DTO_MAP = new ConcurrentHashMap<>(128);

    /**
     * 收款状态
     */
    public enum CollectionStatus {
        /**
         * 代收款
         */
        COLLECTION(1),
        /**
         * 收款中
         */
        RECEIVING(2),
        /**
         * 收款成功
         */
        COLLECTION_SUCCESSFUL(3);

        private Integer code;

        CollectionStatus(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return code;
        }
    }

}
