package com.pcloud.book.mq.topic;

import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.reading.biz.ReadingActivityBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.wechatgroup.message.dto.AddWXGroupDTO;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues = MQTopicConumer.ADD_WXGROUP)
public class AddWxGroupListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(AddWxGroupListener.class);

    @Autowired
    private GroupQrcodeBiz groupQrcodeBiz;
    @Autowired
    private ReadingActivityBiz readingActivityBiz;

    /**
     * 接收微信用户进群消息
     */
    @ParamLog("接收微信用户进群消息")
    @RabbitHandler
    public void onMessage(AddWXGroupDTO addWXGroupDTO) throws BizException {
        try {
            if (addWXGroupDTO == null || addWXGroupDTO.getWechatGroupId() == null || addWXGroupDTO.getMemberCount() == null)
                return;
            groupQrcodeBiz.addOneUser(addWXGroupDTO.getWechatGroupId(), addWXGroupDTO.getMemberCount(),addWXGroupDTO.getNickName(), addWXGroupDTO.getWxId(), addWXGroupDTO.getIp());
            readingActivityBiz.activityUserJoinGroup(addWXGroupDTO);
        } catch (Exception e) {
            LOGGER.error("接收微信用户进群消息失败" + e.getMessage(), e);
        }
    }
}
