package com.pcloud.book.pcloudkeyword.dao;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface PcloudRobotDao extends BaseDao<PcloudRobot> {

    PcloudRobot getByWxId(String wxId);

    PcloudRobot getPcloudRobotByType(Integer robotType);

    void updateWakeUpByClassifyIds(List<Integer> classifyList);

    void clearWakeUp();

    Map<String, RobotClassifyDTO> mapByIds4Classify(List<String> robotIds);

    List<RobotClassifyDTO> getAllPcloudRobot();

    /**
     * 根据编号获取小号
     * @param uniqueNumber
     * @return
     */
    PcloudRobot getByUniqueNumber(String uniqueNumber);

    void updatePcloudRobotByWxId(PcloudRobot pcloudRobot);

    List<String> getPcloudRobotByTypes(List<Integer> classifyIds);

    void updateRobotState(Map<String, Object> map);

    List<RobotClassifyDTO> listSelfRobotByClassify(Map<String, Object> paramMap);
}
