package com.pcloud.book.skill.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.skill.entity.PcloudSkill;
import com.pcloud.book.skill.entity.PcloudSubReply;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("技能参数校验")
public class PcloudSkillCheck {


    @ParamLog("新增技能参数校验")
    public void createPcloudSkillCheck(PcloudSkill pcloudSkill) {
        if (pcloudSkill==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (pcloudSkill.getSkillType()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"技能类型不能为空！");
        }
        if (StringUtil.isEmpty(pcloudSkill.getSkillFuseReply())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"聚合页回复不能为空！");
        }
        checkReply(pcloudSkill.getCancelSubReplies());
        checkReply(pcloudSkill.getSuccessSubReplies());
        checkRemindReply(pcloudSkill.getNoSubReplies());
    }

    private void checkRemindReply(List<PcloudSubReply> list){
        if(!ListUtils.isEmpty(list)) {
            if (list.size() > 3) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "至多填写3条订阅提醒！");
            }
            for (PcloudSubReply reply : list) {
                if (reply == null) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "回复不能为空！");
                }
                if (null == reply.getSubType()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "订阅类型不能为空！");
                }
                if (null == reply.getType()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "回复类型不能为空！");
                }
                Integer type = reply.getType();
                if (ReplyTypeEnum.TEXT.value.equals(type) && StringUtil.isEmpty(reply.getContent())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "内容不能为空！");
                }
                if (ReplyTypeEnum.IMAGE.value.equals(type) && StringUtil.isEmpty(reply.getPicUrl())) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "图片地址不能为空！");
                }
                if (ReplyTypeEnum.APP.value.equals(type) && (StringUtil.isEmpty(reply.getServeType()) || reply.getServeId() == null || StringUtil.isEmpty(reply.getLinkUrl()))) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "应用或作品id和类型、链接不能为空！");
                }
                if (ReplyTypeEnum.RESOURCE.value.equals(type) && reply.getResourceId() == null) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "资源id不能为空！");
                }
                if (null == reply.getRemindIntervalTime()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "提醒间隔不能为空！");
                }
                if (null == reply.getRemindIntervalTime()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "提醒间隔不能为空！");
                }
                if (null == reply.getSubLinkConfirm()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "是否发送订阅链接不能为空！");
                }
                if (1 == reply.getSubLinkConfirm() && null == reply.getSubLinkIntroduce()) {
                    throw new BookBizException(BookBizException.PARAM_IS_ERROR, "快速订阅链接介绍不能为空！");
                }
            }
        }
    }

    private void checkReply(List<PcloudSubReply> list){
        if (ListUtils.isEmpty(list)){
            return;
        }
        for (PcloudSubReply reply :list){
            if (reply==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复不能为空！");
            }
            if (null == reply.getSubType()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "订阅回复类型不能为空！");
            }
            if (null == reply.getType()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "回复类型不能为空！");
            }
            Integer type = reply.getType();
            if (ReplyTypeEnum.TEXT.value.equals(type) && StringUtil.isEmpty(reply.getContent())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "内容不能为空！");
            }
            if (ReplyTypeEnum.IMAGE.value.equals(type) && StringUtil.isEmpty(reply.getPicUrl())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "图片地址不能为空！");
            }
            if (ReplyTypeEnum.APP.value.equals(type) && (StringUtil.isEmpty(reply.getServeType()) || reply.getServeId() == null ||StringUtil.isEmpty(reply.getLinkUrl()))) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "应用或作品id和类型、链接不能为空！");
            }
            if (ReplyTypeEnum.RESOURCE.value.equals(type) && reply.getResourceId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "资源id不能为空！");
            }
        }
    }

    @ParamLog("修改技能校验")
    public void updatePcloudSkill(PcloudSkill pcloudSkill) {
        if (pcloudSkill.getId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"id不能为空！");
        }
        createPcloudSkillCheck(pcloudSkill);
    }
}
