package com.pcloud.book.advertising.biz;

import com.pcloud.book.advertising.dto.BmRegisterDTO;
import com.pcloud.book.advertising.dto.OptionType;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.common.exceptions.BizException;

import java.util.List;
import java.util.Map;

/**
 * @描述：报名
 * @作者：zhuyajie
 * @创建时间：20:03 2019/6/27
 * @版本：1.0
 */
public interface BmBiz {

    /**
     * 获取选项类型
     * @return
     * @throws BizException
     */
    List<OptionType> getOptionType() throws BizException;

    /**
     * 获取选项数据类型
     * @return
     * @throws BizException
     */
    List<OptionType> getOptionDataType() throws BizException;

    /**
     * 新增选项列表
     * @param advertisingBmOptionList
     */
    void addOptionList(List<AdvertisingBmOption> advertisingBmOptionList,Long adId);

    /**
     * 新增选项配置
     * @param bmOption 选项实体
     * @return
     * @throws BizException
     */
    Long addOption(AdvertisingBmOption bmOption) throws BizException;
    /**
     * 根据应用ID获取选项列表信息
     * @param adId 选项实体
     * @return
     * @throws BizException
     */
    List<AdvertisingBmOption> getByAdId(Long adId);

    /**
     * 修改选项配置
     * @param bmOption 选项实体
     * @return
     * @throws BizException
     */
    void modifyOption(AdvertisingBmOption bmOption) throws BizException;

    /**
     * 删除选项
     * @param adId
     */
    void deleteByAdId(Long adId);

    /**
     * 用户提交表单
     * @param bmRegister
     * @param wechatUserId
     * @return
     */
    Long userSubmit(AdvertisingBmRegister bmRegister, Long wechatUserId, Long qrcodeId);
    /**
     * 微信端获取个人报名详情
     * @param adId 应用ID
     * @param wechatUserId 用户ID
     * @return
     * @throws BizException
     */
    List<BmRegisterDTO> getDetail4Wechat(Long adId, Long wechatUserId, Long qrcodeId) throws BizException;

    /**
     * 获取报名次数
     * @param adId
     * @return
     */
    public Long getRegisterCountByAdId(Long adId, String statisMonth);

    /**
     * 获取微信群报名次数
     * @param adId
     * @param statisMonth
     * @param qrcodeId
     * @return
     */
    public Long getRegisterCountByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId);

    /**
     * 获取报名次数
     * @param adIdList
     * @return
     */
    Long getRegisterCountByAdIds(List<Long> adIdList);

    /**
     * 导出报名表单
     * @param adId
     */
    Map<String, Object> exportRegisterInfoByAdId(Long adId,Long qrcodeId);
}
