package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @描述：报名选项
 * @作者：zhuyajie
 * @创建时间：20:05 2019/6/27
 * @版本：1.0
 */
public interface BmOptionDao extends BaseDao<AdvertisingBmOption> {

    /**
     * 获取报名列表
     * @param adId
     * @return
     */
    List<AdvertisingBmOption> getByAdId(Long adId);

    /**
     * 批量删除
     * @param optionIds
     */
    void deleteByIds(List<Long> optionIds);

    /**
     * 根据广告id获取选项id列表
     * @param adId
     * @return
     */
    List<Long> getOptionIdsByAdId(Long adId);
}
