package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.BmRegisterDTO;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @描述：报名记录
 * @作者：zhuyajie
 * @创建时间：20:06 2019/6/27
 * @版本：1.0
 */
public interface BmRegisterDao extends BaseDao<AdvertisingBmRegister> {

    /**
     * 获取用户报名信息
     * @param paramMap
     * @return
     */
    List<BmRegisterDTO> getDetailByUser(Map<String, Object> paramMap);

    /**
     * 获取报名数量
     * @param adId
     * @return
     */
    Long getRegisterCountByAdId(Long adId, String statisMonth);

    /**
     * 报名数量
     * @param adIdList
     * @return
     */
    Long getRegisterCountByAdIds(List<Long> adIdList);

    /**
     * 查报名信息
     * @param adId
     * @return
     */
    List<BmRegisterDTO> exportRegisterInfoById(Long adId, Long qrcodeId);

    /**
     * 获取微信群报名次数
     * @param adId
     * @param statisMonth
     * @param qrcodeId
     * @return
     */
    Long getRegisterCountByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId);
}
