package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.BmOptionDao;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：报名选项
 * @作者：zhuyajie
 * @创建时间：20:14 2019/6/27
 * @版本：1.0
 */
@Component("bmOptionDao")
public class BmOptionDaoImpl extends BaseDaoImpl<AdvertisingBmOption> implements BmOptionDao {
    @Override
    public List<AdvertisingBmOption> getByAdId(Long adId) {
        return getSessionTemplate().selectList(getStatement("getByAdId"), adId);
    }

    @Override
    public void deleteByIds(List<Long> optionIds) {
        getSessionTemplate().delete(getStatement("deleteByIds"), optionIds);
    }

    @Override
    public List<Long> getOptionIdsByAdId(Long adId) {
        return getSessionTemplate().selectList(getStatement("getOptionIdsByAdId"), adId);
    }
}
