package com.pcloud.book.advertising.dto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.common.dto.BaseDto;

/**
 * @author PENG
 */
public class AdvertisingSpaceDTO extends BaseDto {

    private static final long serialVersionUID = -1774181367397964304L;

    /**
     * advertising_space.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_space.ad_name (广告位名称)
     */
    private String adName;

    /**
     * advertising_space.ad_position (广告位置)
     */
    private String adPosition;

    /**
     * advertising_space.ad_position_mode (广告位置方式)
     */
    private String adPositionMode;

    /**
     * advertising_space.ad_position_detail (具体广告位置)
     */
    private String adPositionDetail;

    /**
     * 广告位置名称
     */
    private String adPositionName;

    /**
     * advertising_space.master_id (广告主ID)
     */
    private Long masterId;

    /**
     * 广告主名称
     */
    private String masterName;

    /**
     * advertising_space.ad_link (广告位链接)
     */
    private String adLink;

    /**
     * advertising_space.source_id (对方id)
     */
    private String sourceId;

    /**
     * advertising_space.ad_title (广告位标题)
     */
    private String adTitle;

    /**
     * advertising_space.ad_slogan (广告位文案)
     */
    private String adSlogan;

    /**
     * advertising_space.ad_pic (广告位图片)
     */
    private String adPic;

    /**
     * advertising_space.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * advertising_space.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * advertising_space.is_open (是否打开)
     */
    private Boolean isOpen;

    /**
     * 是否测试
     */
    private Boolean isTest;

    /**
     * 投放书刊数量
     */
    private Integer bookNum;

    /**
     * 投放书刊名称
     */
    private String bookName;

    /**
     * 书刊ID
     */
    private Long bookId;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 点击读者量
     */
    private Long clickUserNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 累积消费
     */
    private BigDecimal totalIncome;

    /**
     * 结算方式
     */
    private String settlementMethod;

    /**
     * 结算方式名称
     */
    private String settlementMethodName;

    /**
     * 每次价格
     */
    private BigDecimal priceEachTime;

    /**
     * 投放时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date distributionTime;

    /**
     * 微信群ID
     */
    private Long qrcodeId;

    /**
     * 微信群名称
     */
    private String groupQrcodeName;

    /**
     * 书号
     */
    private String isbn;

    /**
     * 出版社ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;

    /**
     * 编辑ID
     */
    private Long adviserId;

    /**
     * 运营ID
     */
    private Long channelId;
    /**
     *广告详情方式
     */
    private String adDetailMode;
    /**
     *广告详情封面
     */
    private String adDetailCoverPic;
    /**
     *广告详情优惠图
     */
    private String adDetailWelfarePic;
    /**
     *广告详情介绍
     */
    private String adDetailInfo;
    /**
     *广告详情文件ID
     */
    private String adDetailFileId;
    /**
     *广告详情文件转码状态
     */
    private Integer adDetailFileConvertState;
    /**
     *广告详情文件路径
     */
    private String adDetailFileUrl;
    /**
     *广告详情文件标题
     */
    private String adDetailTitle;
    /**
     *广告详情文件试播秒数
     */
    private Long adDetailFilePilotSecond;
    /**
     *广告详情文件试播路径
     */
    private String adDetailFilePilotUrl;
    /**
     *广告详情文件试播结束提示
     */
    private String adDetailFilePilotFinishTip;
    /**
     *广告报名表单是否校验手机号
     */
    private Boolean adFormMobileCheck;
    /**
     *广告报名表单备注
     */
    private String adFormRemark;
    /**
     *广告报名表单提交按钮
     */
    private String adFormButton;
    /**
     *广告报名表单跳转链接
     */
    private String adFormLink;
    /**
     * 报名选项设置
     */
    private List<AdvertisingBmOption> advertisingBmOptionList;

    /**
     * 报名量
     */
    private Long registerNum;
    /**
     * 报名率
     */
    private BigDecimal registerRate;

    /**
     * 广告详情文件大小
     */
    private Long adDetailFileSize;
    /**
     * 广告详情文件名称
     */
    private String adDetailFileName;

    /**
     * 广告详情文件时长
     */
    private Long adDetailFileDuration;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getAdPosition() {
        return adPosition;
    }

    public void setAdPosition(String adPosition) {
        this.adPosition = adPosition;
    }

    public String getAdLink() {
        return adLink;
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAdSlogan() {
        return adSlogan;
    }

    public void setAdSlogan(String adSlogan) {
        this.adSlogan = adSlogan;
    }

    public String getAdPic() {
        return adPic;
    }

    public void setAdPic(String adPic) {
        this.adPic = adPic;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Integer getBookNum() {
        return bookNum;
    }

    public void setBookNum(Integer bookNum) {
        this.bookNum = bookNum;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getAdPositionMode() {
        return adPositionMode;
    }

    public void setAdPositionMode(String adPositionMode) {
        this.adPositionMode = adPositionMode;
    }

    public String getAdPositionDetail() {
        return adPositionDetail;
    }

    public void setAdPositionDetail(String adPositionDetail) {
        this.adPositionDetail = adPositionDetail;
    }

    public Long getMasterId() {
        return masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public String getAdTitle() {
        return adTitle;
    }

    public void setAdTitle(String adTitle) {
        this.adTitle = adTitle;
    }

    public String getMasterName() {
        return masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public String getSettlementMethodName() {
        return settlementMethodName;
    }

    public void setSettlementMethodName(String settlementMethodName) {
        this.settlementMethodName = settlementMethodName;
    }

    public BigDecimal getPriceEachTime() {
        return priceEachTime;
    }

    public void setPriceEachTime(BigDecimal priceEachTime) {
        this.priceEachTime = priceEachTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public String getAdPositionName() {
        return adPositionName;
    }

    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    public String getAdDetailMode() {
        return adDetailMode;
    }

    public void setAdDetailMode(String adDetailMode) {
        this.adDetailMode = adDetailMode;
    }

    public String getAdDetailCoverPic() {
        return adDetailCoverPic;
    }

    public void setAdDetailCoverPic(String adDetailCoverPic) {
        this.adDetailCoverPic = adDetailCoverPic;
    }

    public String getAdDetailWelfarePic() {
        return adDetailWelfarePic;
    }

    public void setAdDetailWelfarePic(String adDetailWelfarePic) {
        this.adDetailWelfarePic = adDetailWelfarePic;
    }

    public String getAdDetailInfo() {
        return adDetailInfo;
    }

    public void setAdDetailInfo(String adDetailInfo) {
        this.adDetailInfo = adDetailInfo;
    }

    public String getAdDetailFileId() {
        return adDetailFileId;
    }

    public void setAdDetailFileId(String adDetailFileId) {
        this.adDetailFileId = adDetailFileId;
    }

    public Integer getAdDetailFileConvertState() {
        return adDetailFileConvertState;
    }

    public void setAdDetailFileConvertState(Integer adDetailFileConvertState) {
        this.adDetailFileConvertState = adDetailFileConvertState;
    }

    public String getAdDetailFileUrl() {
        return adDetailFileUrl;
    }

    public void setAdDetailFileUrl(String adDetailFileUrl) {
        this.adDetailFileUrl = adDetailFileUrl;
    }

    public String getAdDetailTitle() {
        return adDetailTitle;
    }

    public void setAdDetailTitle(String adDetailTitle) {
        this.adDetailTitle = adDetailTitle;
    }

    public Long getAdDetailFilePilotSecond() {
        return adDetailFilePilotSecond;
    }

    public void setAdDetailFilePilotSecond(Long adDetailFilePilotSecond) {
        this.adDetailFilePilotSecond = adDetailFilePilotSecond;
    }

    public String getAdDetailFilePilotUrl() {
        return adDetailFilePilotUrl;
    }

    public void setAdDetailFilePilotUrl(String adDetailFilePilotUrl) {
        this.adDetailFilePilotUrl = adDetailFilePilotUrl;
    }

    public String getAdDetailFilePilotFinishTip() {
        return adDetailFilePilotFinishTip;
    }

    public void setAdDetailFilePilotFinishTip(String adDetailFilePilotFinishTip) {
        this.adDetailFilePilotFinishTip = adDetailFilePilotFinishTip;
    }

    public Boolean getAdFormMobileCheck() {
        return adFormMobileCheck;
    }

    public void setAdFormMobileCheck(Boolean adFormMobileCheck) {
        this.adFormMobileCheck = adFormMobileCheck;
    }

    public String getAdFormRemark() {
        return adFormRemark;
    }

    public void setAdFormRemark(String adFormRemark) {
        this.adFormRemark = adFormRemark;
    }

    public String getAdFormButton() {
        return adFormButton;
    }

    public void setAdFormButton(String adFormButton) {
        this.adFormButton = adFormButton;
    }

    public String getAdFormLink() {
        return adFormLink;
    }

    public void setAdFormLink(String adFormLink) {
        this.adFormLink = adFormLink;
    }

    public Boolean getIsTest() {
        return isTest;
    }

    public void setIsTest(Boolean isTest) {
       this.isTest = isTest;
    }

    public List<AdvertisingBmOption> getAdvertisingBmOptionList() {
        return advertisingBmOptionList;
    }

    public void setAdvertisingBmOptionList(List<AdvertisingBmOption> advertisingBmOptionList) {
        this.advertisingBmOptionList = advertisingBmOptionList;
    }

    public Long getRegisterNum() {
        return registerNum;
    }

    public void setRegisterNum(Long registerNum) {
        this.registerNum = registerNum;
    }

    public BigDecimal getRegisterRate() {
        return registerRate;
    }

    public void setRegisterRate(BigDecimal registerRate) {
        this.registerRate = registerRate;
    }

    public Long getAdDetailFileSize() {
        return adDetailFileSize;
    }

    public void setAdDetailFileSize(Long adDetailFileSize) {
        this.adDetailFileSize = adDetailFileSize;
    }

    public String getAdDetailFileName() {
        return adDetailFileName;
    }

    public void setAdDetailFileName(String adDetailFileName) {
        this.adDetailFileName = adDetailFileName;
    }

    public Long getAdDetailFileDuration() {
        return adDetailFileDuration;
    }

    public void setAdDetailFileDuration(Long adDetailFileDuration) {
        this.adDetailFileDuration = adDetailFileDuration;
    }

    @Override
    public String toString() {
        return "AdvertisingSpaceDTO{" +
                "id=" + id +
                ", adName='" + adName + '\'' +
                ", adPosition='" + adPosition + '\'' +
                ", adPositionMode='" + adPositionMode + '\'' +
                ", adPositionDetail='" + adPositionDetail + '\'' +
                ", adPositionName='" + adPositionName + '\'' +
                ", masterId=" + masterId +
                ", masterName='" + masterName + '\'' +
                ", adLink='" + adLink + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", adTitle='" + adTitle + '\'' +
                ", adSlogan='" + adSlogan + '\'' +
                ", adPic='" + adPic + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isOpen=" + isOpen +
                ", isTest=" + isTest +
                ", bookNum=" + bookNum +
                ", bookName='" + bookName + '\'' +
                ", bookId=" + bookId +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", clickUserNum=" + clickUserNum +
                ", clickRate=" + clickRate +
                ", totalIncome=" + totalIncome +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", settlementMethodName='" + settlementMethodName + '\'' +
                ", priceEachTime=" + priceEachTime +
                ", distributionTime=" + distributionTime +
                ", qrcodeId=" + qrcodeId +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", isbn='" + isbn + '\'' +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", adviserId=" + adviserId +
                ", channelId=" + channelId +
                ", adDetailMode='" + adDetailMode + '\'' +
                ", adDetailCoverPic='" + adDetailCoverPic + '\'' +
                ", adDetailWelfarePic='" + adDetailWelfarePic + '\'' +
                ", adDetailInfo='" + adDetailInfo + '\'' +
                ", adDetailFileId='" + adDetailFileId + '\'' +
                ", adDetailFileConvertState=" + adDetailFileConvertState +
                ", adDetailFileUrl='" + adDetailFileUrl + '\'' +
                ", adDetailTitle='" + adDetailTitle + '\'' +
                ", adDetailFilePilotSecond=" + adDetailFilePilotSecond +
                ", adDetailFilePilotUrl='" + adDetailFilePilotUrl + '\'' +
                ", adDetailFilePilotFinishTip='" + adDetailFilePilotFinishTip + '\'' +
                ", adFormMobileCheck=" + adFormMobileCheck +
                ", adFormRemark='" + adFormRemark + '\'' +
                ", adFormButton='" + adFormButton + '\'' +
                ", adFormLink='" + adFormLink + '\'' +
                ", advertisingBmOptionList=" + advertisingBmOptionList +
                ", registerNum=" + registerNum +
                ", registerRate=" + registerRate +
                ", adDetailFileSize=" + adDetailFileSize +
                ", adDetailFileName='" + adDetailFileName + '\'' +
                ", adDetailFileDuration=" + adDetailFileDuration +
                '}';
    }
}