package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

/**
 * 报名记录
 */
public class AdvertisingBmRegister extends BaseEntity{

    /**
     *用户id
     */
    private Long userId;
    /**
     *广告id
     */
    private Long adId;
    /**
     *用户昵称
     */
    private String nickName;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;
    /**
     * 报名选项信息
     */
    private List<AdvertisingBmRegisterItem> bmRegisterItemList;
    /**
     * 群二维码id
     */
    private Long qrcodeId;


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAdId() {
        return adId;
    }

    public void setAdId(Long adId) {
        this.adId = adId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName == null ? null : nickName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<AdvertisingBmRegisterItem> getBmRegisterItemList() {
        return bmRegisterItemList;
    }

    public void setBmRegisterItemList(List<AdvertisingBmRegisterItem> bmRegisterItemList) {
        this.bmRegisterItemList = bmRegisterItemList;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    @Override
    public String toString() {
        return "AdvertisingBmRegister{" +
                "userId=" + userId +
                ", adId=" + adId +
                ", nickName='" + nickName + '\'' +
                ", createTime=" + createTime +
                ", bmRegisterItemList=" + bmRegisterItemList +
                ", qrcodeId=" + qrcodeId +
                '}';
    }
}