package com.pcloud.book.advertising.facade.impl;

import com.pcloud.book.advertising.biz.BmBiz;
import com.pcloud.book.advertising.entity.AdvertisingBmOption;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.book.advertising.facade.BmFacade;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * 报名
 */
@RestController("bmFacade")
@RequestMapping("/bm")
public class BmFacadeImpl implements BmFacade {

	@Autowired
	private BmBiz bmBiz;


	/**
	 * 获取选项类型
	 */
	@Override
	@RequestMapping(value = "getOptionType",method = RequestMethod.GET)
	public ResponseDto<?> getOptionType(@RequestHeader("token") String token)
			throws PermissionException, BizException, JsonParseException {
		SessionUtil.getToken4Redis(token);
		return new ResponseDto<>(bmBiz.getOptionType());
	}
	/**
	 * 获取选项数据类型
	 */
	@RequestMapping(value = "/getOptionDataType",method = RequestMethod.GET)
	@Override
	public ResponseDto<?> getOptionDataType(@RequestHeader("token") String token)
			throws PermissionException, BizException, JsonParseException {
		SessionUtil.getToken4Redis(token);
		return new ResponseDto<>(bmBiz.getOptionDataType());
	}

	/**
	 * 用户提交表单
	 */
	@Override
	@RequestMapping(value = "/userSubmit4Wechat",method = RequestMethod.POST)
	public ResponseDto<?> userSubmit4Wechat(@CookieValue("userInfo") String userInfo,
											@RequestBody AdvertisingBmRegister bmRegister)
			throws PermissionException, BizException, JsonParseException {
		Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
		Long qrcodeId = Cookie.getId(userInfo, Cookie.QRCODE_ID);
		if (bmRegister == null) {
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		bmRegister.setUserId(wechatUserId);
		Long result = bmBiz.userSubmit(bmRegister, wechatUserId, qrcodeId);
		return new ResponseDto<>(result);
	}

	/**
	 * 微信端获取个人报名详情
	 */
	@Override
	@RequestMapping(value = "/getDetail4Wechat",method = RequestMethod.GET)
	public ResponseDto<?> getDetail4Wechat(@CookieValue("userInfo") String userInfo, @RequestParam(value = "adId") Long adId)
			throws PermissionException, BizException, JsonParseException {
		Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
		Long qrcodeId = Cookie.getId(userInfo, Cookie.QRCODE_ID);
		if (null == adId) {
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		return new ResponseDto<>(bmBiz.getDetail4Wechat(adId, wechatUserId,qrcodeId));
	}

	/**
	 * 报名信息导出
	 */
	@Override
	@RequestMapping(value = "/exportRegisterInfoByAdId",method = RequestMethod.GET)
	public ResponseDto<Map<String, Object>> exportRegisterInfoByAdId(
			@RequestHeader("token")String token, @RequestParam("adId")Long adId,
			@RequestParam(value = "qrcodeId",required = false) Long qrcodeId) throws PermissionException, BizException, JsonParseException {
		if (null == adId){
			throw new BookBizException(BookBizException.PARAM_IS_ERROR, "参数有误！");
		}
		SessionUtil.getInfoToken4Redis(token);
		Map<String, Object> map =bmBiz.exportRegisterInfoByAdId(adId, qrcodeId);
		return new ResponseDto<>(map);
	}

}
