package com.pcloud.book.advertising.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.pcloud.book.advertising.biz.AdvertisingSpaceBiz;
import com.pcloud.book.advertising.service.AdvertisingSpaceService;
import com.pcloud.common.exceptions.BizException;

/**
 * Description 广告位内部接口实现类
 * Created by PENG on 2019/5/6.
 */
@RestController("advertisingSpaceService")
@RequestMapping("advertisingSpaceService")
public class AdvertisingSpaceServiceImpl implements AdvertisingSpaceService {

    @Autowired
    private AdvertisingSpaceBiz advertisingSpaceBiz;

    /**
     * 每日凌晨计算昨日广告位收益
     */
    @Override
    @RequestMapping(value = "calculateAdvertisingIncomeYesterday", method = RequestMethod.GET)
    public void calculateAdvertisingIncomeYesterday() throws BizException {
        advertisingSpaceBiz.calculateAdvertisingIncomeYesterday();
    }
}
