package com.pcloud.book.consumer.app;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Repository;

import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.appcenter.app.service.AppService;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * 应用接口
 * 
 * @author 作者 : lili
 * @date 创建时间：2016年12月2日 下午7:09:15
 * @version 1.0
 * @return
 */
@Repository("appConsr")
public class AppConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AppConsr.class);

	@Autowired
	private AppService appService;

	/**
	 * 获取审核通过的应用
	 */
	public Map<Long, AppDto> listPassById(List<Long> appIds) throws BizException {
		LOGGER.info("获取审核通过的应用[appService.listPassById],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.listPassById(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取审核通过的应用[appService.listPassById]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取审核通过的应用[appService.listPassById]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取审核通过的应用失败~!");
		}
		return appDtos;
	}

	/**
	 * 获取应用基本信息
	 * 
	 * @param appIds
	 * @param object
	 * @return
	 */
	public Map<Long, AppDto> mapByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.mapByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.mapByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	public Map<Long, AppDto> mapBaseByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.mapByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.mapBaseByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	/**
	 * 获取应用基本信息
	 * @param appIds 应用ID列表
	 * @return
	 */
	public Map<Long, AppDto> getBaseByIds(List<Long> appIds) {
		LOGGER.info("获取应用基本信息[appService.getBaseByIds],参数列表[appIds]:" + appIds);
		Map<Long, AppDto> appDtos = new HashMap<>();
		if (ListUtils.isEmpty(appIds)) {
			return appDtos;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, AppDto>>> appDtosEntity = appService.getBaseByIds(appIds);
			appDtos = ResponseHandleUtil.parseMapResponse(appDtosEntity, Long.class, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("获取应用基本信息[appService.getBaseByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取应用基本信息[appService.getBaseByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取应用基本信息失败~!");
		}
		return appDtos;
	}

	/**
	 * 根据id获取应用基本信息
	 *
	 * @param appId 应用ID
	 * @return
	 */
	public AppDto getBaseById(Long appId) {
		LOGGER.info("根据id获取应用基本信息[appService.getBaseById],参数列表[getBaseById]:" + appId);
		AppDto appDto = null;
		if (appId == null) {
			return appDto;
		}
		try {
			ResponseEntity<ResponseDto<AppDto>> appDtosEntity = appService.getBaseById(appId);
			appDto = ResponseHandleUtil.parseResponse(appDtosEntity, AppDto.class);
		} catch (BizException e) {
			LOGGER.warn("根据id获取应用基本信息[appService.getBaseById]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("根据id获取应用基本信息[appService.getBaseById]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "根据id获取应用基本信息失败~!");
		}
		return appDto;
	}

}
