package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.group.facade.GroupQrcodeFacade;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.ListQrcodeByClassifyParamVO;
import com.pcloud.book.group.vo.UpdateGroupQrcodeRequestVO;
import com.pcloud.book.group.vo.WechatGroupNameVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2019/4/19 15:36
 */
@RestController("groupQrcodeFacade")
@RequestMapping("groupQrcode")
public class GroupQrcodeFacadeImpl implements GroupQrcodeFacade {

    @Autowired
    private GroupQrcodeBiz groupQrcodeBiz;

    @GetMapping("listAllGroupQrcode")
    public ResponseDto<PageBeanNew> listAllGroupQrcode(@RequestHeader("token") String token,
                                                         @RequestParam(value = "wxGroupName", required = false) String wxGroupName,
                                                         @RequestParam("currentPage") Integer currentPage,
                                                         @RequestParam("numPerPage") Integer numPerPage) {
        return new ResponseDto<>(groupQrcodeBiz.listAllGroupQrcode(wxGroupName, currentPage, numPerPage));
    }

    @PostMapping("updateGroupQrcode")
    public ResponseDto<Void> updateGroupQrcode(@RequestHeader("token") String token, @RequestBody UpdateGroupQrcodeRequestVO vo) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(partyId);
        groupQrcodeBiz.updateGroupQrcode(vo);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("listQrcodeByClassify")
    public ResponseDto<PageBeanNew> listQrcodeByClassify(@RequestHeader("token") String token, @RequestBody ListQrcodeByClassifyParamVO listQrcodeByClassifyParamVO) {
        PageBeanNew<ClassifyQrcodeVO> listAllClassify = groupQrcodeBiz.listQrcodeByClassify(listQrcodeByClassifyParamVO);
        return new ResponseDto<>(listAllClassify);
    }

    @Override
    @PostMapping("modifyWechatGroupName")
    @ApiOperation("修改微信群名称")
    public ResponseDto<?> modifyWechatGroupName(@RequestHeader("token") String token, @RequestBody WechatGroupNameVO wechatGroupNameVO)
            throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        groupQrcodeBiz.modifyWechatGroupName(wechatGroupNameVO.getWechatGroupName(), wechatGroupNameVO.getId(), partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getBaseById")
    public ResponseDto<GroupQrcodeBaseInfoVO> getBaseById(@RequestHeader("token")String token, @RequestParam("groupQrcodeId") Long groupQrcodeId) throws BizException, JsonParseException, PermissionException {
        GroupQrcodeBaseInfoVO groupQrcodeBaseInfoVO = groupQrcodeBiz.getBaseById(groupQrcodeId);
        return new ResponseDto<>(groupQrcodeBaseInfoVO == null ? new GroupQrcodeBaseInfoVO() : groupQrcodeBaseInfoVO);
    }

    @GetMapping("addUser")
    ResponseDto<?> addUser(@RequestParam("weixinGroupId") String weixinGroupId, @RequestParam("userNumber") Integer userNumber)
            throws BizException{
        groupQrcodeBiz.addOneUser(weixinGroupId, userNumber, null, null);
        return new ResponseDto<>();
    }

    @GetMapping("updateUserNumber")
    ResponseDto<?> updateUserNumber(@RequestParam("weixinGroupId") String weixinGroupId)
            throws BizException{
        groupQrcodeBiz.updateUserNumber(weixinGroupId);
        return new ResponseDto<>();
    }
}
