package com.pcloud.book.push.facade;

import com.pcloud.book.push.dto.PushPlanDTO;
import com.pcloud.book.push.entity.MorningEveningNews;
import com.pcloud.book.push.entity.Push;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.book.push.entity.PushItem;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:49
 **/
@FeignClient(value = "pcloud-service-book",qualifier = "pushFacadeCloud",path = "push")
@Api(description = "推送群消息外部接口")
public interface PushFacade {

    @ApiOperation("新增群发")
    @PostMapping("/createPush")
    ResponseDto<?> createPush(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发模型") Push push
    ) throws BizException, PermissionException;

    @ApiOperation("更新群发")
    @PostMapping("/updatePush")
    ResponseDto<?> updatePush(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发模型") Push push
    ) throws BizException, PermissionException;

    @ApiOperation("删除群发")
    @GetMapping("/deletePush")
    ResponseDto<?> deletePush(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("pushId") @ApiParam("群发id") Long pushId
    ) throws BizException, PermissionException;

    @ApiOperation("批量新增群发关联")
    @PostMapping("/createPushGroupBatch")
    ResponseDto<?> createPushGroupBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发关联模型集合") List<PushGroup> pushGroups
    ) throws BizException, PermissionException;

    @ApiOperation("批量删除群发关联")
    @PostMapping("/deletePushGroupBatch")
    ResponseDto<?> deletePushGroupBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发关联id集合") List<Long> pushGroupIds
    ) throws BizException, PermissionException;

    @ApiOperation("新增群发项")
    @PostMapping("/createPushItem")
    ResponseDto<?> createPushItem(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发项") PushItem pushItem
    ) throws BizException, PermissionException;

    @ApiOperation("删除群发项")
    @GetMapping("/deletePushItem")
    ResponseDto<?> deletePushItem(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("pushItemId") @ApiParam("群发项") Long pushItemId
    ) throws BizException, PermissionException;

    @ApiOperation("群发项排序")
    @PostMapping("/sortPushItems")
    ResponseDto<?> sortPushItems(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发项id集合") List<Long> pushItemIds
    ) throws BizException, PermissionException;

    @ApiOperation("获取定时群发列表")
    @GetMapping("/getTimingPushList")
    ResponseDto<?> getTimingPushList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("更新群发消息状态为成功")
    @GetMapping("/updatePushStateSuccess")
    void updatePushStateSuccess(@RequestParam("pushGroupRecordId") @ApiParam("群发记录id") Integer pushGroupRecordId)throws BizException;

    @ApiOperation("修改群发时间")
    @PostMapping("/updatePushTime")
    ResponseDto<?> updatePushTime(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发模型") Push push
    ) throws BizException, PermissionException;

    @ApiOperation("获取群发关联集合")
    @GetMapping("/getPushGroupList")
    ResponseDto<?> getPushGroupList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("pushId") @ApiParam("群发id") Long pushId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取群发记录列表")
    @GetMapping("/getPushRecordList")
    ResponseDto<?> getPushRecordList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("新增早晚报")
    @PostMapping("/createMorningEveningNews")
    ResponseDto<?> createMorningEveningNews(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("早晚报模型") MorningEveningNews morningEveningNews
    ) throws BizException, PermissionException;

    @ApiOperation("修改早晚报")
    @PostMapping("/updateMorningEveningNews")
    ResponseDto<?> updateMorningEveningNews(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("新增早晚报模型") MorningEveningNews morningEveningNews
    ) throws BizException, PermissionException;

    @ApiOperation("获取早晚报")
    @GetMapping("/getMorningEveningNews")
    ResponseDto<?> getMorningEveningNews(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException;


    @ApiOperation("新增计划式群发")
    @PostMapping("/createPushPlan")
    ResponseDto<?> createPushPlan(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发模型") PushPlanDTO pushPlanDTO
    ) throws BizException, PermissionException;


    @ApiOperation("修改计划式群发")
    @PostMapping("/updatePushPlan")
    ResponseDto<?> updatePushPlan(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("群发计划模型") PushPlanDTO pushPlanDTO
    ) throws BizException, PermissionException;

    @ApiOperation("根据id获取计划式群发")
    @GetMapping("/getPushPlan")
    ResponseDto<?> getPushPlan(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("pushPlanId") Long pushPlanId
    ) throws BizException, PermissionException;

    @ApiOperation("删除计划式群发")
    @GetMapping("/deletePushPlan")
    ResponseDto<?> deletePushPlan(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("pushPlanId") Long pushPlanId
    ) throws BizException, PermissionException;

    @ApiOperation("获取计划列表")
    @GetMapping("/getPushPlanList")
    ResponseDto<?> getPushPlanList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "keyword", required = false) @ApiParam("社群码名称、书名、分类名") String keyword,
            @RequestParam(value = "day", required = false) @ApiParam("日期") String day,
            @RequestParam(value = "weekDay", required = false) @ApiParam("周几") Integer weekDay,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取计划日历")
    @GetMapping("/getPushPlanCalendar")
    ResponseDto<?> getPushPlanCalendar(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException;

}
