package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletBookUserScoreDTO;

import java.util.List;

public interface AppletBookScoreBiz {

    /**
     * 为小程序本书服务评分
     *
     * @param wechatUserId 用户ID
     * @param bookId       图书ID
     * @param channelId    渠道ID
     * @param adviserId    编辑ID
     * @param scoreTagId   评价
     * @return 主键ID
     */
    Long score(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Long scoreTagId);

    /**
     * 获取本书服务评价信息
     * @param wechatUserId 用户ID
     * @param bookId 图书ID
     * @param channelId 渠道ID
     * @param adviserId 评价
     * @return
     */
    List<AppletBookUserScoreDTO> get(Long wechatUserId, Long bookId, Long channelId, Long adviserId);
}
