package com.pcloud.book.applet.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.applet.biz.AppletBookScoreBiz;
import com.pcloud.book.applet.dto.AppletBookScoreTagDTO;
import com.pcloud.book.applet.dto.AppletBookScoreTagInfoDTO;
import com.pcloud.book.applet.dto.AppletBookUserScoreDTO;
import com.pcloud.book.applet.entity.AppletBookUserScore;
import com.pcloud.book.applet.mapper.AppletBookScoreMapper;
import com.pcloud.book.applet.mapper.AppletBookUserScoreMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class AppletBookScoreBizImpl implements AppletBookScoreBiz {

    @Autowired
    private AppletBookUserScoreMapper appletBookUserScoreMapper;
    @Autowired
    private AppletBookScoreMapper appletBookScoreMapper;

    @Override
    public Long score(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Long scoreTagId) {
        AppletBookUserScore appletBookUserScore = new AppletBookUserScore();
        appletBookUserScore.setWechatUserId(wechatUserId);
        appletBookUserScore.setBookId(bookId);
        appletBookUserScore.setChannelId(channelId);
        appletBookUserScore.setAdviserId(adviserId);
        appletBookUserScore.setScoreTagId(scoreTagId);

        // 不存在则新增
        Long primaryKey = appletBookUserScoreMapper.selectPrimaryKey(appletBookUserScore);
        if (Objects.isNull(primaryKey)) {
            appletBookUserScoreMapper.insert(appletBookUserScore);
            return appletBookUserScore.getId();
        }

        // 存在则更新
        appletBookUserScore.setId(primaryKey);
        appletBookUserScoreMapper.updateByPrimaryKey(appletBookUserScore);
        return primaryKey;
    }

    @Override
    public List<AppletBookUserScoreDTO> get(Long wechatUserId, Long bookId, Long channelId, Long adviserId) {

        List<AppletBookScoreTagInfoDTO> dtos = appletBookScoreMapper.listTags(wechatUserId, bookId, channelId, adviserId);
        Map<Long, List<AppletBookScoreTagDTO>> tagsMap = dtos.stream().collect(
                Collectors.groupingBy(AppletBookScoreTagInfoDTO::getScoreId, Collectors.mapping(item -> {
                    AppletBookScoreTagDTO tag = new AppletBookScoreTagDTO();
                    tag.setTagId(item.getTagId());
                    tag.setTagName(item.getTagName());
                    tag.setChosen(item.getChosen() == 1);
                    tag.setChooseTime(item.getChosenTime());
                    return tag;
                }, Collectors.toList())));

        ArrayList<AppletBookUserScoreDTO> result = new ArrayList<>();
        if (CollUtil.isEmpty(tagsMap)) return result;


        dtos.stream().collect(Collectors.toMap(AppletBookScoreTagInfoDTO::getScoreId, AppletBookScoreTagInfoDTO::getScoreName, (key1, key2) -> key1)).forEach((scoreId, scoreName) -> {
            AppletBookUserScoreDTO appletBookUserScoreDTO = new AppletBookUserScoreDTO();
            appletBookUserScoreDTO.setScoreId(scoreId);
            appletBookUserScoreDTO.setScoreName(scoreName);
            appletBookUserScoreDTO.setWechatUserId(wechatUserId);
            appletBookUserScoreDTO.setTags(Optional.of(tagsMap).map(map -> map.get(scoreId)).orElse(new ArrayList<>()));
            result.add(appletBookUserScoreDTO);
        });
        return result;
    }
}
