package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("小程序banner")
public class AppletBannerDTO extends BaseDto {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("banner图")
    private String bannerPic;

    @ApiModelProperty("跳转类型 1指定页面, 2web页面, 3资讯, 4应用作品")
    private Integer jumpType;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;

    @ApiModelProperty("排序值")
    private Integer seq;

    @ApiModelProperty("是否展示")
    private Boolean showState;

    @ApiModelProperty("点击量PV/UV")
    private String clickPVUV;

    @ApiModelProperty("咨询的选择方式 1自定义， 2自动获取")
    private Integer fillType;

    @ApiModelProperty("作品/应用/咨询的ID")
    private Long serveId;

    @ApiModelProperty("作品/应用/咨询的类型")
    private Integer serveType;

    @ApiModelProperty("咨询具体信息")
    private AppletNewsDTO newsItem;

    @ApiModelProperty("咨询具体信息")
    private ServeItemInfoDTO appItem;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("上架时间")
    private Date startTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("下架时间")
    private Date endTime;
}
