package com.pcloud.book.book.facade;

import com.pcloud.book.book.vo.FeedbackParam;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lily
 * @date 2018/10/31 15:43
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookTempletFeedbackFacadeCloud", path = "book/v1.0/bookTempletFeedback")
@Api(description = "图书类型反馈外部服务")
public interface BookTempletFeedbackFacade {
    @ApiOperation(value = "新增图书类型反馈", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "feedbackParam", value = "反馈内容", dataType = "FeedbackParam", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody FeedbackParam feedbackParam)
            throws BizException, PermissionException;

}
