package com.pcloud.book.copyright.facade;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;
import com.pcloud.book.copyright.vo.CodeUseStatusVO;
import com.pcloud.book.copyright.vo.FileVO;
import com.pcloud.book.copyright.vo.ImportRecordVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author lily
 * @date 2018/11/29 16:58
 */
@Api(description = "授权码")
public interface BookAuthCodeFacade {

    @ApiOperation(value = "校验授权码", httpMethod = "POST")
    @RequestMapping(value = "checkCode", method = RequestMethod.POST)
    ResponseDto<CodeUseStatusVO> checkCode(@CookieValue("userInfo") String userInfo, @RequestBody CheckCodeParam checkCodeParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "校验服务是否需要验证", httpMethod = "POST")
    @RequestMapping(value = "checkServe", method = RequestMethod.POST)
    ResponseDto<Boolean> checkServe(@CookieValue("userInfo") String userInfo, @RequestBody CheckIsAuthServeParam checkIsAuthServeParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "校验服务是否需要验证", httpMethod = "POST")
    @RequestMapping(value = "importCode", method = RequestMethod.POST)
    ResponseDto<?> importCode(@RequestHeader("token") String token, @RequestBody FileVO fileVO)
            throws PermissionException, BizException;

    @ApiOperation(value = "授权码导入记录", httpMethod = "GET")
    @RequestMapping(value = "importCodeRecord", method = RequestMethod.GET)
    ResponseDto<PageBeanNew<ImportRecordVO>> importCodeRecord(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                                              @RequestParam("channelId") Long channelId, @RequestParam(value = "authBookType", required = false) Integer authBookType,
                                                              @RequestParam("currentPage") Integer currenPage, @RequestParam("numPerPage") Integer numPerPage)
            throws PermissionException, BizException;

    @ApiOperation(value = "获取授权码列表", httpMethod = "GET")
    @RequestMapping(value = "getCodeList", method = RequestMethod.GET)
    ResponseDto<PageBeanNew<BookAuthCodeDTO>> getCodeList(@RequestHeader("token") String token,
                                                          @RequestParam("bookId") Long bookId,
                                                          @RequestParam("channelId") Long channelId,
                                                          @RequestParam(required = false,value = "keyword")String keyword,
                                                          @RequestParam(required = false,value = "state")Integer state,
                                                          @RequestParam(required = false,value = "authBookType")Integer authBookType,
                                                          @RequestParam("currentPage") Integer currentPage,
                                                          @RequestParam("numPerPage") Integer numPerPage)
            throws PermissionException, BizException;

    @ApiOperation(value = "批量删除正版授权码", httpMethod = "POST")
    @RequestMapping(value = "batchDeleteCode", method = RequestMethod.POST)
    ResponseDto<PageBeanNew<BookAuthCodeDTO>> batchDeleteCode(@RequestHeader("token") String token,
                                                          @RequestBody List<Long> ids)
            throws PermissionException, BizException;


    /**
     * 导出授权码
     * @param token
     * @param bookId
     * @param codeIds
     * @param channelId
     * @param status
     * @return
     * @throws PermissionException
     * @throws JsonParseException
     * @throws BizException
     */
    @ApiOperation(value = "导出授权码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token",value = "token",dataType = "String",paramType = "header"),
            @ApiImplicitParam(name = "bookId",value = "书ID",dataType = "long",paramType = "query"),
            @ApiImplicitParam(name = "codeIds",value = "授权码ID(用“，”隔开)",dataType = "String",paramType = "query"),
            @ApiImplicitParam(name = "channelId",value = "商品ID",dataType = "long",paramType = "query"),
            @ApiImplicitParam(name = "status",value = "查询状态（0-全部导出，1-部分导出）",dataType = "long",paramType = "query")
    })
    @RequestMapping(value = "/exportCode",method = RequestMethod.GET)
    ResponseDto<?> exportCode(@RequestHeader("token") String token,
                                 @RequestParam(required = false, value ="bookId") Long bookId,
                                 @RequestParam(required = false, value ="codeIds") String codeIds,
                                 @RequestParam(required = false, value ="channelId") Long channelId,
                                 @RequestParam(required = false, value ="status") Long status,
                                 @RequestParam(required = false,value = "authBookType")Integer authBookType)
            throws PermissionException, JsonParseException,BizException;

}
