package com.pcloud.book.custom.dao.impl;

import com.pcloud.book.custom.dao.CustomTimeControlDao;
import com.pcloud.book.custom.dto.CustomTimeControlDTO;
import com.pcloud.book.custom.dto.CustomTimeControlPageDTO;
import com.pcloud.book.custom.entity.CustomTimeControl;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("customTimeControlDao")
public class CustomTimeControlDaoImpl extends BaseDaoImpl<CustomTimeControl> implements CustomTimeControlDao {
    @Override
    public int deleteByPrimaryKey(Integer id) {
        return getSessionTemplate().delete(getStatement("deleteByPrimaryKey"),id);
    }


    @Override
    public CustomTimeControl selectByPrimaryKey(Integer id) {
        return getSessionTemplate().selectOne(getStatement("selectByPrimaryKey"),id);
    }

    @Override
    public int updateByPrimaryKeySelective(CustomTimeControl record) {
        return getSessionTemplate().update(getStatement("updateByPrimaryKeySelective"),record);
    }

    @Override
    public int updateByPrimaryKey(CustomTimeControl record) {
        return getSessionTemplate().update(getStatement("updateByPrimaryKey"),record);
    }

    @Override
    public List<CustomTimeControlPageDTO> getCustomTimeControlPage(String taskName) {
        return getSessionTemplate().selectList(getStatement("getCustomTimeControlPage"),taskName);
    }

    @Override
    public CustomTimeControlDTO getCustomTimeControlById(Integer id) {
        return getSessionTemplate().selectOne(getStatement("getCustomTimeControlById"),id);
    }
}
