package com.pcloud.book.personalstage.dto;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel("定制化阶段跳转关键词")
@Data
public class PersonalStageJumpKeywordDto extends BaseEntity {

    private Long id;

    @ApiModelProperty("阶段id")
    private Long personalStageId;

    @ApiModelProperty("定制化阶段跳转id")
    private Long personalStageJumpId;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("跳转类型：1读者输入关键词触发，2小睿发送关键词触发，3转账触发")
    private Integer jumpType;

    @ApiModelProperty("跳转后阶段id")
    private Long afterPersonalStageId;
}