package com.pcloud.book.reading.dto;

import com.pcloud.book.reading.entity.ReadingInvite;
import com.pcloud.book.reading.entity.ReadingUser;
import com.pcloud.common.dto.BaseDto;

import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel("共读活动基本设置")
public class ReadingActivityBaseParamDTO extends BaseDto{

    @ApiModelProperty("活动id")
    private Long id;

    @ApiModelProperty("活动主题")
    private String theme;

    @ApiModelProperty("品牌方id")
    private Long brandId;

    @ApiModelProperty("入群条件（1无限制2回复关键词3转账）")
    private Integer joinCondition;

    @ApiModelProperty("入群关键词")
    private String joinKeyword;

    @ApiModelProperty("入群转账金额")
    private BigDecimal joinAmount;

    @ApiModelProperty("入群方式（1邀请链接/2群二维码）")
    private Integer joinType;

    @ApiModelProperty("入群二维码图片")
    private String joinQrcodePic;

    @ApiModelProperty("群规类型（1文本2文件）")
    private Integer ruleType;

    @ApiModelProperty("群规")
    private String rule;

    @ApiModelProperty("群规文件资源id")
    private String ruleResourceId;

    @ApiModelProperty("活动开始时间")
    private String startTime;

    @ApiModelProperty("开场语类型（1文本2文件）")
    private Integer startSloganType;

    @ApiModelProperty("开场语")
    private String startSlogan;

    @ApiModelProperty("开场语资源id")
    private String startResourceId;

    @ApiModelProperty("活动结束时间")
    private String endTime;

    @ApiModelProperty("结束语（1文本2文件）")
    private Integer endSloganType;

    @ApiModelProperty("结束语")
    private String endSlogan;

    @ApiModelProperty("结束语资源id")
    private String endResourceId;

    @ApiModelProperty("邀请时间")
    private String inviteTime;

    @ApiModelProperty("邀请语设置")
    private List<ReadingInvite> inviteList;

    @ApiModelProperty("邀请用户")
    private List<ReadingUser> userList;

    @ApiModelProperty("创建人")
    private Long createUser;

    }