package com.pcloud.book.test;

import com.alibaba.fastjson.JSON;
import com.pcloud.book.BookApplication;
import com.pcloud.book.elasticsearch7.entity.Es7Book;
import com.pcloud.book.elasticsearch7.search.domain.dto.param.PlatformSearchDto;
import com.pcloud.book.elasticsearch7.search.facade.PlatformBookSearchFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.universe.commons.paging.Pagination;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {BookApplication.class})
public class PlatformBookSearchFacadeTest {

    @Autowired
    private PlatformBookSearchFacade platformBookSearchFacade;

    @Test
    public void testSearch() {
        PlatformSearchDto dto = new PlatformSearchDto();
        dto.setFundName(" 上海基金");

        ResponseDto<Pagination<Es7Book>> r = platformBookSearchFacade.search(dto);

        log.info(JSON.toJSONString(r));
    }
}
