package com.pcloud.book.personalstage.biz.impl;

import com.google.common.collect.Lists;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.custom.mapper.CustomPlanModuleSuggestionMapper;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.mq.delay.DelayMessageSender;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.personalstage.biz.PersonalStageBiz;
import com.pcloud.book.personalstage.biz.PersonalStageJumpBiz;
import com.pcloud.book.personalstage.check.PersonalStageCheck;
import com.pcloud.book.personalstage.constant.PersonalStageConstant;
import com.pcloud.book.personalstage.dao.PersonalStageDao;
import com.pcloud.book.personalstage.dao.PersonalStageJumpDao;
import com.pcloud.book.personalstage.dao.PersonalStageJumpKeywordDao;
import com.pcloud.book.personalstage.dao.PersonalStageJumpLinkupDao;
import com.pcloud.book.personalstage.dao.PersonalStageProgressMessageDao;
import com.pcloud.book.personalstage.dao.PersonalStageReplyDao;
import com.pcloud.book.personalstage.dao.PersonalStageReplyItemDao;
import com.pcloud.book.personalstage.dao.PersonalStageUserDao;
import com.pcloud.book.personalstage.dao.PersonalStageWakeupDao;
import com.pcloud.book.personalstage.dto.FusingFinishDelayDTO;
import com.pcloud.book.personalstage.dto.PersonalStageDTO;
import com.pcloud.book.personalstage.dto.PersonalStageJumpKeywordDto;
import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.dto.WakeupDelayDTO;
import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.book.personalstage.entity.PersonalStageReply;
import com.pcloud.book.personalstage.entity.PersonalStageReplyItem;
import com.pcloud.book.personalstage.entity.PersonalStageUser;
import com.pcloud.book.personalstage.entity.PersonalStageWakeup;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.book.personalstage.enums.PersonalStageUserStateEnum;
import com.pcloud.book.personalstage.enums.SendModeEnum;
import com.pcloud.book.personalstage.enums.StageReplyRelevEnum;
import com.pcloud.book.personalstage.utils.CacheUtils;
import com.pcloud.book.personalstage.vo.request.AddScoreRequestVO;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.wechatgroup.group.dto.GroupRobotDTO;
import com.pcloud.wechatgroup.group.dto.GroupUserDTO;
import com.sdk.wxgroup.SendFileVO;
import com.sdk.wxgroup.SendMessageTypeEnum;
import com.sdk.wxgroup.SendPicMessageVO;
import com.sdk.wxgroup.SendTextMessageVO;
import com.sdk.wxgroup.WxGroupSDK;
import com.sdk.wxgroup.im.mimc.BusinessConstant;
import com.sdk.wxgroup.im.mimc.dto.SendMomentsDTO;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

@Component("personalStageBiz")
public class PersonalStageBizImpl implements PersonalStageBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(PersonalStageBizImpl.class);

    @Autowired
    private PersonalStageDao personalStageDao;
    @Autowired
    private PersonalStageReplyDao personalStageReplyDao;
    @Autowired
    private PersonalStageReplyItemDao personalStageReplyItemDao;
    @Autowired
    private PersonalStageWakeupDao personalStageWakeupDao;
    @Autowired
    private PersonalStageCheck personalStageCheck;
    @Autowired
    private PersonalStageJumpDao personalStageJumpDao;
    @Autowired
    private PcloudRobotClassifyDao pcloudRobotClassifyDao;
    @Autowired
    private PcloudRobotDao pcloudRobotDao;
    @Autowired
    private PersonalStageUserDao personalStageUserDao;
    @Autowired
    private DelayMessageSender delayMessageSender;
    @Autowired
    private PersonalStageJumpKeywordDao personalStageJumpKeywordDao;
    @Autowired
    private PersonalStageJumpBiz personalStageJumpBiz;
    @Autowired
    private WechatGroupConsr wechatGroupConsr;
    @Autowired
    private PersonalStageProgressMessageDao personalStageProgressMessageDao;
    @Autowired
    private PersonalStageJumpLinkupDao personalStageJumpLinkupDao;
    @Autowired
    private ResourceConsr resourceConsr;
    @Autowired
    private CustomPlanModuleSuggestionMapper customPlanModuleSuggestionMapper;

    @Value("${wechat.group.link.prefix}")
    private String wechatLinkPrefix;

    private final static String PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE = "${PROGRESS_URL}";
    //需求单链接替换符
    private final static String PERSONAL_STAGE_PAPER_TEMPLATE = "${PROGRESS_URL&amp;ProgressId}";
    //需求单链接替换符
    private final static String PERSONAL_STAGE_PAPER_TEMPLATE1 = "${PROGRESS_URL&ProgressId}";

    // 项目进度路由
    private final static String PERSONAL_STAGE_PROJECT_PROGRESS = "/personalCenter/projectProgress";

    //需求定制单路由  https://wechat666.raysgo.com/personalCenter/questionNaire?paperId=679
    private final static String PERSONAL_STAGE_PAPER = "/personalCenter/questionNaire?paperId=";

    private final static String USER_SEND_CONTENT="${USER_SEND_CONTENT}";

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("新增阶段")
    @Override
    public Long createPersonalStage(PersonalStage personalStage) {
        personalStageCheck.createPersonalStageParamCheck(personalStage);
        Integer maxSeqNum = personalStageDao.getMaxSeqNum();
        personalStage.setSeqNum(maxSeqNum+1);
        personalStageDao.insert(personalStage);
        addWakeAndReply(personalStage);
        return personalStage.getId();
    }

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("修改阶段")
    @Override
    public void updatePersonalStage(PersonalStage personalStage) {
        personalStageCheck.updatePersonalStageParamCheck(personalStage);
        personalStageDao.update(personalStage);
        deleteAddWakeAndReply(personalStage.getId());
        addWakeAndReply(personalStage);
    }

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("删除阶段")
    @Override
    public void deletePersonalStage(Long id) {
        if (id==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"id不能为空！");
        }
        //校验是否是某个阶段的下一个阶段
        Integer count = personalStageJumpDao.getCountByPersonalStageId(id);
        if (count>0){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"该阶段为某个阶段的下一阶段，不能删除！");
        }
        personalStageDao.deleteById(id);
        deleteAddWakeAndReply(id);
    }

    @ParamLog("获取定制化阶段")
    @Override
    public PersonalStage getPersonalStage(Long id) {
        PersonalStage personalStage = personalStageDao.getById(id);
        if (personalStage==null){
            throw new BookBizException(BookBizException.ERROR,"没有该记录");
        }
        List<PersonalStageReply> replies = personalStageReplyDao.getListByPersonalStageId(id);
        Map<Long,List<PersonalStageReply>> wakeupReplyMap=new HashMap<>();
        if (!ListUtils.isEmpty(replies)){
            List<Long> replyIds=replies.stream().map(PersonalStageReply::getId).collect(Collectors.toList());
            List<PersonalStageReplyItem> replyItems = personalStageReplyItemDao.getListByReplyIds(replyIds);
            if (!ListUtils.isEmpty(replyItems)){
                fillReplyItems(replyItems);
                Map<Long,List<PersonalStageReplyItem>> itemMap=replyItems.stream().collect(Collectors.groupingBy(PersonalStageReplyItem::getPersonalStageReplyId));
                for (PersonalStageReply reply:replies){
                    reply.setPersonalStageReplyItems(itemMap.get(reply.getId()));
                }
            }
            personalStage.setStageNotKeywordReplies(replies.stream().filter(s->StageReplyRelevEnum.STAGE_NOT_KEYWORD.value.equals(s.getRelevanceType())).collect(Collectors.toList()));
            personalStage.setFusingNotKeywordReplies(replies.stream().filter(s->StageReplyRelevEnum.FUSING_NOT_KEYWORD.value.equals(s.getRelevanceType())).collect(Collectors.toList()));
            List<PersonalStageReply> wakeupReplies=replies.stream().filter(s->StageReplyRelevEnum.WAKEUP.value.equals(s.getRelevanceType())).collect(Collectors.toList());
            wakeupReplyMap=wakeupReplies.stream().collect(Collectors.groupingBy(PersonalStageReply::getRelevanceId));
        }
        List<PersonalStageWakeup> wakeups = personalStageWakeupDao.getListByPersonalStageId(id);
        for (PersonalStageWakeup wakeup:wakeups){
            wakeup.setWakeupReplies(wakeupReplyMap.get(wakeup.getId()));
        }
        personalStage.setPersonalStageWakeups(wakeups);
        return personalStage;
    }

    @ParamLog("填充回复项")
    private void fillReplyItems(List<PersonalStageReplyItem> replyItems) {
        if (ListUtils.isEmpty(replyItems)){
            return;
        }
        List<Long> resourceIds=replyItems.stream().filter(s->(ReplyTypeEnum.RESOURCE.value.equals(s.getReplyType())
                ||ReplyTypeEnum.AUDIO.value.equals(s.getReplyType()))&&s.getResourceId()!=null).map(PersonalStageReplyItem::getResourceId).collect(Collectors.toList());
        if (ListUtils.isEmpty(resourceIds)){
            return;
        }
        Map<Long, ResourceDTO> resourceDTOMap = resourceConsr.mapByIds(resourceIds);
        for (PersonalStageReplyItem item:replyItems){
            Integer type=item.getReplyType();
            if (ReplyTypeEnum.RESOURCE.value.equals(type)||ReplyTypeEnum.AUDIO.value.equals(type)){
                ResourceDTO resourceDTO = resourceDTOMap.get(item.getResourceId());
                if (resourceDTO!=null){
                    item.setResourceName(resourceDTO.getResourceName());
                    item.setResourceUrl(resourceDTO.getFileUrl());
                    item.setResourceTypeCode(resourceDTO.getTypeCode());
                    item.setResourceTypeName(resourceDTO.getTypeName());
                    item.setFileType(resourceDTO.getFileType());
                    item.setResourcePdfItems(resourceDTO.getResourcePdfItems());
                    item.setResourceOfficeItemDTOs(resourceDTO.getResourceOfficeItemDTOs());
                    item.setFileSize(resourceDTO.getFileSize());
                }
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("修改排序值")
    @Override
    public void updateSeqNum(PersonalStage personalStage) {
        if (personalStage==null||personalStage.getId()==null||personalStage.getSeqNum()==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数有误！");
        }
        personalStageDao.updateSeqNum(personalStage.getId(),personalStage.getSeqNum());
    }

    @ParamLog("删除唤醒和回复")
    private void deleteAddWakeAndReply(Long personalStageId) {
        List<Long> replyIds = personalStageReplyDao.getIdsByPersonalStageId(personalStageId);
        personalStageReplyDao.deleteByIds(replyIds);
        personalStageReplyItemDao.deleteByReplyIds(replyIds);
        personalStageWakeupDao.deleteByPersonalStageId(personalStageId);
    }

    @ParamLog("新增唤醒和回复")
    private void addWakeAndReply(PersonalStage personalStage) {
        Long personalStageId = personalStage.getId();
        List<PersonalStageReply> allReply=new ArrayList<>();
        if (!ListUtils.isEmpty(personalStage.getPersonalStageWakeups())){
            for (PersonalStageWakeup wakeup:personalStage.getPersonalStageWakeups()){
                wakeup.setPersonalStageId(personalStageId);
            }
            personalStageWakeupDao.batchInsert(personalStage.getPersonalStageWakeups());
            for (PersonalStageWakeup wakeup:personalStage.getPersonalStageWakeups()){
                Long wakeupId=wakeup.getId();
                for (PersonalStageReply reply:wakeup.getWakeupReplies()){
                    reply.setRelevanceType(StageReplyRelevEnum.WAKEUP.value);
                    reply.setRelevanceId(wakeupId);
                    reply.setPersonalStageId(personalStageId);
                }
                allReply.addAll(wakeup.getWakeupReplies());
            }
        }
        for (PersonalStageReply reply:personalStage.getStageNotKeywordReplies()){
            reply.setRelevanceType(StageReplyRelevEnum.STAGE_NOT_KEYWORD.value);
            reply.setPersonalStageId(personalStageId);
            reply.setRelevanceId(personalStageId);
        }
        allReply.addAll(personalStage.getStageNotKeywordReplies());
        for (PersonalStageReply reply:personalStage.getFusingNotKeywordReplies()){
            reply.setRelevanceType(StageReplyRelevEnum.FUSING_NOT_KEYWORD.value);
            reply.setPersonalStageId(personalStageId);
            reply.setRelevanceId(personalStageId);
        }
        allReply.addAll(personalStage.getFusingNotKeywordReplies());
        personalStageReplyDao.batchInsert(allReply);
        List<PersonalStageReplyItem> allItems=new ArrayList<>();
        for (PersonalStageReply reply:allReply){
            Long replyId=reply.getId();
            for (PersonalStageReplyItem item:reply.getPersonalStageReplyItems()){
                item.setPersonalStageReplyId(replyId);
            }
            allItems.addAll(reply.getPersonalStageReplyItems());
        }
        personalStageReplyItemDao.batchInsert(allItems);
    }

    /**
     * 获取阶段列表
     */
    @Override
    public PageBean getPersonalStageList(Long robotClassifyId, PageParam pageParam) throws BizException {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("robotClassifyId", robotClassifyId);
        PageBean pageBean = personalStageDao.listPage(pageParam, paramMap, "getPersonalStageList");
        if (null == pageBean || ListUtils.isEmpty(pageBean.getRecordList())){
            return new PageBean();
        }
        //衔接语数量
        Map<Long, PersonalStageDTO> linkupCountMap = personalStageJumpLinkupDao.mapStageJumpLinkupCountByRobotClassify(robotClassifyId);
        for (Object object : pageBean.getRecordList()){
            PersonalStageDTO stageDTO = (PersonalStageDTO) object;
            if (!MapUtils.isEmpty(linkupCountMap) && linkupCountMap.containsKey(stageDTO.getId())){
                PersonalStageDTO linkup = linkupCountMap.get(stageDTO.getId());
                stageDTO.setJumpLinkupCount(linkup.getJumpLinkupCount());
            }
        }
        return pageBean;
    }

    /**
     * 获取阶段列表
     */
    @Override
    public List<PersonalStageDTO> getPersonalStageListNoPage(Long robotClassifyId) throws BizException {
        return personalStageDao.getPersonalStageList(robotClassifyId);
    }

    @Transactional(rollbackFor = Exception.class)
    @ParamLog("发送关键词时处理用户定制化阶段")
    @Override
    public void userSendPersonalStage(String userWxId,String ip,Integer code,String robotId, String content) {
        Boolean hasRecord;
        PersonalStageUser last = personalStageUserDao.getLast(userWxId, robotId, null);
        PersonalStage personalStage;
        if (last!=null){
            hasRecord=true;
            personalStage=personalStageDao.getById(last.getPersonalStageId());
        }else {
            hasRecord=false;
            PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(robotId);
            Long robotClassifyId=pcloudRobot.getRobotType().longValue();
            personalStage = personalStageDao.getFirstStage(robotClassifyId);
        }
        Boolean iskeyword;
        if (StringUtil.isEmpty(content)){
            iskeyword=false;
        }else {
            //关键词库查询
            PersonalStageJumpKeywordDto dto=personalStageJumpKeywordDao.getByKeyword(personalStage.getId(),content, JumpTypeEnum.READER_TRIGGER.key);
            if (dto!=null){
                iskeyword=true;
            }else {
                iskeyword=false;
            }
        }
        //是关键词且有记录
        if (iskeyword){
            LOGGER.info("是关键词且有记录");
            String key = "PERSONAL_STAGE_JUMP_KEYWORD_LOCK".concat(userWxId).concat(robotId);
            try {
                // 加锁，一条一条数据进行处理
                while (!CacheUtils.lock(key)) {
                    Thread.sleep(100);
                }
                //调关键词处理逻辑
                personalStageJumpBiz.handlePersonalStageJump(userWxId,robotId,content,JumpTypeEnum.READER_TRIGGER);
            } catch (Exception e){
                LOGGER.info("缓存加锁失败，userWxId=" + userWxId +" robotId="+robotId);
            } finally {
                CacheUtils.unlock(key);
            }
        }
        //不是关键词且有记录
        if (!iskeyword&&hasRecord){
            //判断是否已经达到熔断标准
            if (personalStage!=null){
                Integer notKeywordSendCount =getSendNKeywordCountFromCache(personalStage.getId(),userWxId,robotId);
                if ((notKeywordSendCount!=null&&notKeywordSendCount>=personalStage.getNotKeywordFusingCount())
                      ||PersonalStageUserStateEnum.FUSING.value.equals(last.getState())){
                    // 走熔断
                    LOGGER.info("走熔断");
                    handleFusingReply(robotId,userWxId,ip,personalStage,last, personalStage.getPaperId());
                }else {
                    //走正常逻辑非关键词回复并且更新记录
                    if (PersonalStageUserStateEnum.NORMAL.value.equals(last.getState())
                        ||PersonalStageUserStateEnum.WAKEUP.value.equals(last.getState())){
                        LOGGER.info("走正常逻辑非关键词回复并且更新记录notKeywordSendCount:{}",notKeywordSendCount);
                        //如果是正常状态或者唤醒状态才回复，并且更新状态为正常状态
                        last.setNotKeywordSendCount(notKeywordSendCount+1);
                        last.setState(PersonalStageUserStateEnum.NORMAL.value);
                        personalStageUserDao.update(last);
                        sendNotKeywordReply(robotId,userWxId,ip,personalStage.getId(), last.getId(), content, personalStage.getSendMode(),notKeywordSendCount);
                    }
                }
            }
        }
        //不是关键词且没有记录
        if (!iskeyword&&!hasRecord){
            //走正常非关键词回复并且新增记录
            LOGGER.info("走正常非关键词回复并且新增记录");
            PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(robotId);
            Long robotClassifyId=pcloudRobot.getRobotType().longValue();
            PersonalStage firstStage = personalStageDao.getFirstStage(robotClassifyId);
            PersonalStageUser personalStageUser=new PersonalStageUser();
            personalStageUser.setRobotId(robotId);
            personalStageUser.setWxId(userWxId);
            personalStageUser.setState(PersonalStageUserStateEnum.NORMAL.value);
            personalStageUser.setNotKeywordSendCount(1);
            personalStageUser.setRobotClassifyId(robotClassifyId);
            personalStageUser.setPersonalStageId(firstStage.getId());
            personalStageUserDao.insert(personalStageUser);
            sendNotKeywordReply(robotId,userWxId,ip,personalStage.getId(), personalStageUser.getId(), content,firstStage.getSendMode(), 0);
        }
    }


    @ParamLog("从缓存中获取发送非关键词次数")
    private synchronized Integer getSendNKeywordCountFromCache(Long personalStageId, String wxId, String robotId) {
        String key = PersonalStageConstant.NOT_SEND_KEYWORD_COUNT_LOCK + personalStageId;
        Integer count = 0;
        try {
            while (!CacheUtils.lock(key)) {
                Thread.sleep(100);
            }
            String cacheKey = PersonalStageConstant.USER_SEND_KEYWORD_COUNT_LOCK + personalStageId + "_" + wxId;
            long value = JedisClusterUtils.incr(cacheKey);
            if (value != 1) {
                return (int)value - 1;
            }
            count = personalStageUserDao.getNotKeywordSendCount(wxId, robotId, null);
            count = count == null ? 0 : count;
            JedisClusterUtils.set(cacheKey, (count.longValue() + 1) + "", 10 * 60);
            return count;
        } catch (Exception e) {
            LOGGER.warn("从缓存中获取发送非关键词次数失败，personalStageId=" + personalStageId +"wxId="+wxId+"robotId="+robotId);
        } finally {
            CacheUtils.unlock(key);
        }
        return count;
    }

    @Override
    @ParamLog("判断是否是定制化用户")
    public Boolean isPersonalStageUser(String robotId){
        //判断是否是平台端配置的小号
        try {
            PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(robotId);
            if (pcloudRobot!=null&&pcloudRobot.getRobotType()!=null){
                //查询该分类下的定制化阶段
                Long robotClassifyId=pcloudRobot.getRobotType().longValue();
                PcloudRobotClassify robotClassify = pcloudRobotClassifyDao.getById(robotClassifyId);
                if (robotClassify!=null){
                    //获取该分类下的阶段数量
                    Integer count=personalStageDao.getCountByRobotClassifyId(robotClassifyId);
                    if (count>0){
                        return true;
                    }
                }
            }
        }catch (Exception e) {
            LOGGER.error("判断是否是定制化用户失败" + e.getMessage(), e);
        }
        return false;
    }

    @ParamLog("加好友时插入初始状态")
    @Override
    public Long createAddUserStageUser(String robotId, String userWxId, String ip) {
        //查询第一个阶段
        PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(robotId);
        Long robotClassifyId=pcloudRobot.getRobotType().longValue();
        PersonalStage firstStage = personalStageDao.getFirstStage(robotClassifyId);
        if (firstStage==null){
            return null;
        }
        nextStageAddStageUserAndWakeupDelay (robotId, userWxId, ip, firstStage.getId());
        return firstStage.getId();
    }

    @ParamLog("处理延时唤醒")
    @Override
    public void dealDelayWakeup(DelayQueueDTO dto) {
        String wxId=dto.getKey();
        WakeupDelayDTO wakeupDelayDTO=(WakeupDelayDTO) dto.getMsg();
        //查询该用户最后的阶段
        PersonalStageUser last = personalStageUserDao.getLast(wxId, wakeupDelayDTO.getRobotId(), null);
        Long personalStageId = wakeupDelayDTO.getPersonalStageId();
        //判断用户是否在插入唤醒延时队列的当时阶段且是唤醒状态
        if (last==null||!PersonalStageUserStateEnum.WAKEUP.value.equals(last.getState())
                ||!last.getPersonalStageId().equals(personalStageId)){
            LOGGER.info("用户已跳阶段或者不是唤醒状态"+wakeupDelayDTO.toString());
            return;
        }
        PersonalStage personalStage=personalStageDao.getById(personalStageId);
        if (personalStage==null){
            LOGGER.info("未找到该阶段personalStageId="+personalStageId);
            return;
        }
        Long currentWakeupId=wakeupDelayDTO.getPersonalStageWakeupId();
        //发送唤醒内容
        List<Long> replyIds=personalStageReplyDao.getIdsByRelevance(StageReplyRelevEnum.WAKEUP.value,currentWakeupId);
        if (ListUtils.isEmpty(replyIds)){
            LOGGER.info("没有回复currentWakeupId="+currentWakeupId);
            return;
        }
        List<PersonalStageReplyItem> replyItems = personalStageReplyItemDao.getListByReplyIds(replyIds);
        if (ListUtils.isEmpty(replyItems)){
            LOGGER.info("没有回复项replyIds="+replyIds);
            return;
        }
        String robotId=wakeupDelayDTO.getRobotId();
        String userWxId=wakeupDelayDTO.getWxId();
        String ip=wakeupDelayDTO.getIp();
        this.replacePaperUrl(replyItems, robotId, userWxId, personalStage.getPaperId(),ip);
        //判断人工客服服务状态
        Boolean state = false;
        Integer serviceState = wechatGroupConsr.getServiceStateByRobotUser(robotId, userWxId);
        if (serviceState == 1){
            LOGGER.info("人工客服服务中，userWxId="+userWxId+"+robotId+"+robotId);
            state = true;
        }
        if (!state){//客服介入不发唤醒
            sendReplyItems(replyItems,robotId,userWxId,ip,wakeupDelayDTO.getPersonalStageUserId());
        }
        //下一个延时
        List<PersonalStageWakeup> wakeups = personalStageWakeupDao.getListByPersonalStageId(personalStageId);
        int i=0;
        PersonalStageWakeup currentWakeup=null;
        for (PersonalStageWakeup wakeup:wakeups){
            i=i+1;
            if (currentWakeupId.equals(wakeup.getId())){
                currentWakeup=wakeup;
                break;
            }
        }
        if (currentWakeup!=null&&i>0&&i<wakeups.size()){
            PersonalStageWakeup nextWakeup=wakeups.get(i);
            Integer time=(nextWakeup.getToStageStartTime()-currentWakeup.getToStageStartTime())*1000;
            WakeupDelayDTO wakeupDelayDTONew=new WakeupDelayDTO();
            wakeupDelayDTONew.setPersonalStageWakeupId(nextWakeup.getId());
            wakeupDelayDTONew.setRobotId(robotId);
            wakeupDelayDTONew.setWxId(userWxId);
            wakeupDelayDTONew.setIp(ip);
            wakeupDelayDTONew.setPersonalStageId(personalStageId);
            wakeupDelayDTONew.setPersonalStageUserId(wakeupDelayDTO.getPersonalStageUserId());
            wakeupDelayDTO.setPersonalStageCreateTime(DateUtils.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"));
            DelayQueueDTO delayQueueDTONew = DelayQueueDTO.builder().key(userWxId).type(PersonalStageConstant.PERSONALSTAGE_DELAY_WAKEUP).msg(wakeupDelayDTONew).timeout(time).build();
            delayMessageSender.send(delayQueueDTONew);
            LOGGER.info("下一个延时发送delayQueueDTONew="+delayQueueDTONew.toString());
        }


    }

    @ParamLog("下一阶段新增定制化阶段用户记录和唤醒延时")
    @Override
    public PersonalStageUser nextStageAddStageUserAndWakeupDelay(String robotId, String userWxId, String ip, Long personalStageId) {
        PersonalStageWakeup wakeup = personalStageWakeupDao.getFirstWakeup(personalStageId);
        PersonalStageUser personalStageUser=new PersonalStageUser();
        personalStageUser.setRobotId(robotId);
        personalStageUser.setWxId(userWxId);
        if (wakeup==null){
            //没有唤醒，设置状态为正常状态
            personalStageUser.setState(PersonalStageUserStateEnum.NORMAL.value);
        }else {
            //有唤醒，设置状态为唤醒状态
            personalStageUser.setState(PersonalStageUserStateEnum.WAKEUP.value);
        }
        personalStageUser.setNotKeywordSendCount(0);
        JedisClusterUtils.del(PersonalStageConstant.USER_SEND_KEYWORD_COUNT_LOCK + personalStageId + "_" + userWxId);
        //查询分类
        PcloudRobot pcloudRobot = pcloudRobotDao.getByWxId(robotId);
        Long robotClassifyId=pcloudRobot.getRobotType().longValue();
        personalStageUser.setRobotClassifyId(robotClassifyId);
        personalStageUser.setPersonalStageId(personalStageId);
        personalStageUserDao.insert(personalStageUser);
        //同时插入唤醒队列
        //查询第一个唤醒时长
        if (wakeup==null){
            return personalStageUser;
        }
        Integer toStageStartTime=wakeup.getToStageStartTime();
        WakeupDelayDTO wakeupDelayDTO=new WakeupDelayDTO();
        wakeupDelayDTO.setPersonalStageWakeupId(wakeup.getId());
        wakeupDelayDTO.setRobotId(robotId);
        wakeupDelayDTO.setWxId(userWxId);
        wakeupDelayDTO.setIp(ip);
        wakeupDelayDTO.setPersonalStageId(personalStageId);
        wakeupDelayDTO.setPersonalStageUserId(personalStageUser.getId());
        wakeupDelayDTO.setPersonalStageCreateTime(DateUtils.formatDate(new Date(),"yyyy-MM-dd HH:mm:ss"));
        DelayQueueDTO delayQueueDTO = DelayQueueDTO.builder().key(userWxId).type(PersonalStageConstant.PERSONALSTAGE_DELAY_WAKEUP).msg(wakeupDelayDTO).timeout(toStageStartTime*1000).build();
        delayMessageSender.send(delayQueueDTO);
        return personalStageUser;
    }

    @ParamLog("非关键词回复")
    @Override
    public void sendNotKeywordReply(String robotId, String userWxId, String ip, Long personalStageId, Long personalStageUserId,
                                    String userSendContent, Integer sendMode, Integer count) {
        if("重置体验".equals(userSendContent)){
            return;
        }
        //判断人工客服服务状态
        Integer serviceState = wechatGroupConsr.getServiceStateByRobotUser(robotId, userWxId);
        if (serviceState == 1){
            LOGGER.info("人工客服服务中，userWxId="+userWxId+"+robotId+"+robotId);
            return;
        }
        PersonalStageReply personalStageReply = null;
        List<Long> ids = personalStageReplyDao.getIdsByRelevance(StageReplyRelevEnum.STAGE_NOT_KEYWORD.value, personalStageId);
        Long replyId = null;
        if (ListUtils.isEmpty(ids)){
            return;
        }
        if (SendModeEnum.RADOM.value.equals(sendMode)){
            Random random = new Random();
            replyId=ids.get(random.nextInt(ids.size()));
            personalStageReply = personalStageReplyDao.getById(replyId);
        }else {
            if (null != count){
                if ((count).intValue() >= ids.size()){
                    count = ids.size() -1;
                }
                LOGGER.info(StageReplyRelevEnum.STAGE_NOT_KEYWORD.value +":"+ personalStageId+":"+count);
                personalStageReply = personalStageReplyDao.personalStageReply4Order(StageReplyRelevEnum.STAGE_NOT_KEYWORD.value, personalStageId,count);
                replyId = personalStageReply.getId();
            }else {
                throw new BookBizException(BookBizException.ERROR,"查询到用户发送的非关键词数量为0");
            }
            ids = Lists.newArrayList(replyId);
        }
        List<PersonalStageReplyItem> items = personalStageReplyItemDao.getListByReplyIds(Arrays.asList(replyId));
        if (ListUtils.isEmpty(items)){
            return;
        }
        //替换用户输入内容
        items=replaceUserSendContent(items,ids, userSendContent,robotId,userWxId,ip);
        if (ListUtils.isEmpty(items)){
            return;
        }
        //替换需求定制单链接
        this.replacePaperUrl(items, robotId, userWxId, personalStageReply.getPaperId(),ip);
        sendReplyItems(items,robotId,userWxId,ip,personalStageUserId);
    }

    @ParamLog("替换用户输入内容")
    private List<PersonalStageReplyItem> replaceUserSendContent(List<PersonalStageReplyItem> items, List<Long> ids, String userSendContent, String robotId, String userWxId, String ip) {
        List<PersonalStageReplyItem> replyItems = personalStageReplyItemDao.getListByReplyIds(ids);
        Map<Long,List<PersonalStageReplyItem>> map=replyItems.stream().collect(Collectors.groupingBy(PersonalStageReplyItem::getPersonalStageReplyId));
        List<Long> idsNotHasSpe=new ArrayList<>();
        List<Long> idsHasSpe=new ArrayList<>();
        for (Long id:ids){
            List<PersonalStageReplyItem> ins=map.get(id);
            if (!ListUtils.isEmpty(ins)){
                Boolean normal=true;
                for (PersonalStageReplyItem replyItem:ins){
                    if (!StringUtil.isEmpty(replyItem.getContent())&&replyItem.getContent().contains(USER_SEND_CONTENT)){
                        normal=false;
                    }
                }
                if (normal){
                    idsNotHasSpe.add(id);
                }else {
                    idsHasSpe.add(id);
                }
            }
        }
        List<PersonalStageReplyItem> itemNew=new ArrayList<>();
        //如果用户没有输入文本
        if (StringUtil.isEmpty(userSendContent)){
            //找一个不带占位符的
            if (ListUtils.isEmpty(idsNotHasSpe)){
                SendTextMessageVO sendTextMessageVO = new SendTextMessageVO();
                sendTextMessageVO.setContent("哎哟 ～小主，你给我的不是书名啊。输入一本正在读或者感兴趣的书名，小睿就可以给你秀一下我的独家绝技哦");
                sendTextMessageVO.setAltId(robotId);
                sendTextMessageVO.setWxGroupId(userWxId);
                sendTextMessageVO.setIp(ip);
                sendTextMessageVO.setCode(SendMessageTypeEnum.SELF.getCode());
                WxGroupSDK.sendTextMessage(sendTextMessageVO);
            }else {
                Random random = new Random();
                Long replyId=idsNotHasSpe.get(random.nextInt(idsNotHasSpe.size()));
                itemNew = personalStageReplyItemDao.getListByReplyIds(Arrays.asList(replyId));
            }
            return itemNew;
        }else {
            //用户输入文本优先给带特殊符号的
            if (!ListUtils.isEmpty(idsHasSpe)){
                Random random = new Random();
                Long replyId=idsHasSpe.get(random.nextInt(idsHasSpe.size()));
                itemNew = personalStageReplyItemDao.getListByReplyIds(Arrays.asList(replyId));
                for (PersonalStageReplyItem item:itemNew){
                    Integer type=item.getReplyType();
                    if (ReplyTypeEnum.TEXT.value.equals(type)&&item.getContent().contains(USER_SEND_CONTENT)) {
                        item.setContent(item.getContent().replace(USER_SEND_CONTENT,userSendContent));
                        //保持用户输入的内容
                        String key ="BOOK:USER_SEND_CONTENT:" + userWxId + "-" +robotId;
                        JedisClusterUtils.setJson(key, userSendContent);
                    }
                }
                return itemNew;
            }
        }
        return items;
    }

    @ParamLog("尝试插入单号")
    private void tryInsertNumber(Long personalStageUserId) {
        PersonalStageUser personalStageUser = personalStageUserDao.getById(personalStageUserId);
        if (StringUtil.isEmpty(personalStageUser.getRequireNumber())){
            String requireNumber = DateUtils.formatDate(new Date(), "yyyyMMddHHmmss").concat(String.valueOf((int)((Math.random()*9+1)*100000)));
            personalStageUserDao.updateRequireNumber(personalStageUserId, requireNumber);
        }
       }

    @Override
    @ParamLog("替换进度链接")
    public String replaceProjectProgressUrl(String content, String robotId, String userWxId, Long personalStageUserId, String ip) {
        if(content.indexOf(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_1) > -1){
            tryInsertNumber(personalStageUserId);
            String longUrl = wechatLinkPrefix.concat(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS).concat("?wxUserId=" + userWxId +
                    "&robotId=" + robotId + "&personalStageUserId=" + personalStageUserId + "&progressId=" + PersonalStageConstant.PERSONAL_STAGE_PROGRESS_1);
            content = content.replace(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_1, UrlUtils.getShortUrl4Own(longUrl));
            //添加进度单回复延迟队列
            personalStageJumpBiz.addProgressDelay(userWxId, robotId, ip,PersonalStageConstant.PERSONAL_STAGE_PROGRESS_1);
        }else if (content.indexOf(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_2) > -1){
            tryInsertNumber(personalStageUserId);
            String longUrl = wechatLinkPrefix.concat(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS).concat("?wxUserId=" + userWxId +
                    "&robotId=" + robotId + "&personalStageUserId=" + personalStageUserId + "&progressId=" + PersonalStageConstant.PERSONAL_STAGE_PROGRESS_2);
            content = content.replace(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_2, UrlUtils.getShortUrl4Own(longUrl));
            //添加进度单回复延迟队列
            personalStageJumpBiz.addProgressDelay(userWxId, robotId, ip, PersonalStageConstant.PERSONAL_STAGE_PROGRESS_2);
        }else if (content.indexOf(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_3) > -1){
            tryInsertNumber(personalStageUserId);
            String longUrl = wechatLinkPrefix.concat(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS).concat("?wxUserId=" + userWxId +
                    "&robotId=" + robotId + "&personalStageUserId=" + personalStageUserId + "&progressId=" +PersonalStageConstant.PERSONAL_STAGE_PROGRESS_3);
            content = content.replace(PersonalStageConstant.PERSONAL_STAGE_PROJECT_PROGRESS_TEMPLATE_3, UrlUtils.getShortUrl4Own(longUrl));
            //添加进度单回复延迟队列
            personalStageJumpBiz.addProgressDelay(userWxId, robotId, ip, PersonalStageConstant.PERSONAL_STAGE_PROGRESS_3);
        }
        if (content.indexOf(PersonalStageConstant.CUSTOM_PLAN) > -1) {
            String url = wechatLinkPrefix + "/personalCenter/madeProject?";
            Integer planId = customPlanModuleSuggestionMapper.getLatestPlanId(userWxId);
            if (null != planId) {
                String longUrl = url + "planId=" + planId + "&wxId=" + userWxId + "&robotWxId=" + robotId;
                content = content.replace(PersonalStageConstant.CUSTOM_PLAN, UrlUtils.getShortUrl4Own(longUrl));
            }
        }
        content = replaceUserSendContent(content, robotId, userWxId);
        content = replaceReadingStyle(content, robotId, userWxId);
        return content;
    }

    /**
     * 替换用户发送内容（书名）
     * @param content
     * @param robotId
     * @param userWxId
     * @return
     */
    public String replaceUserSendContent(String content, String robotId, String userWxId) {
        if(content.indexOf(USER_SEND_CONTENT) > -1){
            String key ="BOOK:USER_SEND_CONTENT:" + userWxId + "-" +robotId;
            String userSendContent = JedisClusterUtils.getJson(key, String.class);
            if (!StringUtil.isEmpty(userSendContent)){
                content = content.replace(USER_SEND_CONTENT, userSendContent);
            }
        }
        return content;
    }

    @ParamLog("替换阅读偏好")
    public String replaceReadingStyle(String linkupContent, String robotWxId, String userWxId){
        if (linkupContent.indexOf("${readingStyle=")>-1){
            Integer serchch = linkupContent.indexOf("${readingStyle=");
            String readingStyle= linkupContent.substring(serchch+15,serchch+19);
            String content = linkupContent.substring(serchch,serchch+20);
            if (!StringUtil.isEmpty(readingStyle) && !StringUtil.isEmpty(content)){
                //保持用户输入的内容
                String key ="BOOK:READING_STYLE:" + userWxId + "-" + robotWxId;
                JedisClusterUtils.setJson(key, readingStyle);
                //去掉衔接语这种替换符 ${readingStyle=xxxx}
                linkupContent = linkupContent.replace(content,readingStyle);
            }
        }
        return linkupContent;
    }

    @ParamLog("替换需求定制单链接")
    private void replacePaperUrl(List<PersonalStageReplyItem> items, String robotId, String userWxId, Long paperId, String ip){

        for (PersonalStageReplyItem item : items){
            if(ReplyTypeEnum.TEXT.value.equals(item.getReplyType())){
                if (item.getContent().indexOf(PERSONAL_STAGE_PAPER_TEMPLATE) > -1 ||
                        item.getContent().indexOf(PERSONAL_STAGE_PAPER_TEMPLATE1) > -1) {//包含链接
                    if (null == paperId) {
                        item.setContent(item.getContent().replace(PERSONAL_STAGE_PAPER_TEMPLATE, ""));
                        item.setContent(item.getContent().replace(PERSONAL_STAGE_PAPER_TEMPLATE1, ""));
                        return;
                    }
                    String longUrl = wechatLinkPrefix.concat(PERSONAL_STAGE_PAPER).concat(paperId.toString()).concat("&wxId=" + userWxId + "&robotWxId=" + robotId);
                    //由于前端给的替换符中的“&”可能会是“&amp;”,所以两种替换符都要换掉
                    String shortLink = UrlUtils.getShortUrl4Own(longUrl);
                    item.setContent(item.getContent().replace(PERSONAL_STAGE_PAPER_TEMPLATE, shortLink));
                    item.setContent(item.getContent().replace(PERSONAL_STAGE_PAPER_TEMPLATE1, shortLink));
                    //添加需求单延迟发送队列
                    personalStageJumpBiz.addPaperDelay(userWxId, robotId, ip, paperId);
                }
            }
        }
    }

    @ParamLog("非关键词熔断回复")
    @Override
    public void sendNotKeywordFusingReply(String robotId, String userWxId, String ip, Long personalStageId, Long personalStageUserId, Long paperId) {
        PersonalStage personalStage = personalStageDao.getById(personalStageId);
        PersonalStageUser personalStageUser = personalStageUserDao.getById(personalStageUserId);
        if(personalStage != null && personalStageUser != null) {
            Integer notReplyFusingCount = personalStage.getNotReplyFusingCount();
            if (notReplyFusingCount != null && personalStageUser.getFusingReplyCount() >= personalStage.getNotReplyFusingCount()) {
                return;
            }
        }
        //判断人工客服服务状态
        Integer serviceState = wechatGroupConsr.getServiceStateByRobotUser(robotId, userWxId);
        if (serviceState == 1){
            LOGGER.info("人工客服服务中，userWxId="+userWxId+"+robotId+"+robotId);
            return;
        }
        List<Long> ids = personalStageReplyDao.getIdsByRelevance(StageReplyRelevEnum.FUSING_NOT_KEYWORD.value, personalStageId);
        if (ListUtils.isEmpty(ids)) {
            return;
        }
        Random random = new Random();
        Long replyId = ids.get(random.nextInt(ids.size()));
        List<PersonalStageReplyItem> items = personalStageReplyItemDao.getListByReplyIds(Arrays.asList(replyId));
        if (ListUtils.isEmpty(items)){
            return;
        }
        this.replacePaperUrl(items, robotId, userWxId, paperId,ip);
        sendReplyItems(items,robotId,userWxId,ip,personalStageUserId);
        personalStageUserDao.updateFusingReplyCount(personalStageUserId);
    }

    @ParamLog("发送回复")
    private void sendReplyItems(List<PersonalStageReplyItem> replyItems,String robotId, String userWxId, String ip,Long personalStageUserId){
        for (PersonalStageReplyItem item:replyItems){
            Integer type=item.getReplyType();
            if (ReplyTypeEnum.TEXT.value.equals(type)) {
                SendTextMessageVO sendTextMessageVO = new SendTextMessageVO();
                sendTextMessageVO.setContent(replaceProjectProgressUrl(item.getContent(),robotId,userWxId,personalStageUserId,ip));
                sendTextMessageVO.setAltId(robotId);
                sendTextMessageVO.setWxGroupId(userWxId);
                sendTextMessageVO.setIp(ip);
                sendTextMessageVO.setCode(SendMessageTypeEnum.SELF.getCode());
                WxGroupSDK.sendTextMessage(sendTextMessageVO);
            }
            if (ReplyTypeEnum.IMAGE.value.equals(type)) {
                SendPicMessageVO sendPicMessageVO = new SendPicMessageVO();
                sendPicMessageVO.setWxGroupId(userWxId);
                sendPicMessageVO.setAltId(robotId);
                sendPicMessageVO.setPicUrl(item.getPicUrl());
                sendPicMessageVO.setIp(ip);
                sendPicMessageVO.setCode(SendMessageTypeEnum.SELF.getCode());
                WxGroupSDK.sendPicMessage(sendPicMessageVO);
            }
            if (ReplyTypeEnum.RESOURCE.value.equals(type)) {
                SendFileVO sendFileVO = new SendFileVO();
                Map<Long, ResourceDTO> map = resourceConsr.mapByIds(Arrays.asList(item.getResourceId()));
                ResourceDTO resourceDTO = map.get(item.getResourceId());
                if (resourceDTO != null) {
                    sendFileVO.setFileUrl(resourceDTO.getFileUrl());
                    String fileName = resourceDTO.getResourceName();
                    String fileType = resourceDTO.getFileType();
                    LOGGER.info("fileName="+fileName+"+fileType+"+fileType);
                    if (fileName.contains(fileType)){//去掉后缀
                        fileName = fileName.substring(0, fileName.indexOf(fileType)-1);
                    }
                    LOGGER.info("fileName="+fileName);
                    sendFileVO.setFileName(fileName);
                }
                sendFileVO.setIp(ip);
                sendFileVO.setAltId(robotId);
                sendFileVO.setWxId(userWxId);
                WxGroupSDK.sendFile(sendFileVO);
            }
            if (ReplyTypeEnum.AUDIO.value.equals(type)) {
                SendMomentsDTO sendMomentsDTO=new SendMomentsDTO();
                Map<Long, ResourceDTO> map = resourceConsr.mapByIds(Arrays.asList(item.getResourceId()));
                ResourceDTO resourceDTO = map.get(item.getResourceId());
                if (resourceDTO != null) {
                    GroupRobotDTO info = wechatGroupConsr.getGroupRobotByRobotId(robotId);
                    if (info!=null){
                        sendMomentsDTO.setIsMasterWx(info.getMasterWx());
                        sendMomentsDTO.setReceiveAccount(info.getMac());
                    }
                    sendMomentsDTO.setMomentType(BusinessConstant.MomentTypeEnum.SEND_WX_RECORD);
                    sendMomentsDTO.setContent(userWxId);
                    sendMomentsDTO.setLink(resourceDTO.getFileUrl());
                    sendMomentsDTO.setIp(ip);
                    WxGroupSDK.sendMessageToPhone(sendMomentsDTO);
                }
            }
        }
    }

    @ParamLog("处理熔断回复情况")
    private void handleFusingReply(String robotId, String userWxId, String ip, PersonalStage personalStage, PersonalStageUser last, Long paperId) {
        if (!PersonalStageUserStateEnum.FUSING.value.equals(last.getState())) {
            // 置为熔断状态
            PersonalStageUser user = new PersonalStageUser();
            user.setId(last.getId());
            user.setState(PersonalStageUserStateEnum.FUSING.value);
            user.setNotKeywordSendCount(last.getNotKeywordSendCount()+1);
            personalStageUserDao.update(user);
            // 添加延迟队列
            FusingFinishDelayDTO delayDTO = new FusingFinishDelayDTO();
            delayDTO.setPersonalStageUserId(last.getId());
            delayDTO.setPersonalStageId(personalStage.getId());
            delayDTO.setRobotId(robotId);
            delayDTO.setWxId(userWxId);
            delayDTO.setIp(ip);
            DelayQueueDTO delayQueueDTO = DelayQueueDTO.builder().key(userWxId).type(PersonalStageConstant.PERSONALSTAGE_DELAY_FUSING)
                    .msg(delayDTO).timeout(personalStage.getNotKeywordFusingTime().intValue() * 1000).build();
            delayMessageSender.send(delayQueueDTO);
        }
        String key = "BOOK:PERSONAL_STAGE:FUSING:" + last.getId();
        if (!JedisClusterUtils.exists(key)) {
            // 发送熔断回复消息
            JedisClusterUtils.set(key, "true", 60);
            sendNotKeywordFusingReply(robotId, userWxId, ip, personalStage.getId(), last.getId(), paperId);
        }
    }

    @ParamLog("处理延时熔断结束")
    @Override
    public void dealDelayFusingFinish(DelayQueueDTO dto) {
        String wxId = dto.getKey();
        FusingFinishDelayDTO delayDTO = (FusingFinishDelayDTO) dto.getMsg();
        //查询该用户在该阶段的状态
        Long personalStageId = delayDTO.getPersonalStageId();
        Long personalStageUserId = delayDTO.getPersonalStageUserId();
        PersonalStageUser last = personalStageUserDao.getById(personalStageUserId);
        if (last == null || !PersonalStageUserStateEnum.FUSING.value.equals(last.getState())){
            return;
        }
        PersonalStage personalStage = personalStageDao.getById(personalStageId);
        if (personalStage == null){
            return;
        }
        // 将用户置为正常状态
        PersonalStageUser user = new PersonalStageUser();
        user.setId(personalStageUserId);
        user.setState(PersonalStageUserStateEnum.NORMAL.value);
        user.setNotKeywordSendCount(0);
        user.setFusingReplyCount(0);
        personalStageUserDao.update(user);
        //刪除发送非关键词次数緩存
        JedisClusterUtils.del(PersonalStageConstant.USER_SEND_KEYWORD_COUNT_LOCK + personalStageId + "_" + wxId);
    }

    @Override
    public PersonalStageProgressDTO getPersonalProgress(String wxUserId, Long personalStageUserId, Long progressId) {
        PersonalStageProgressDTO personalStageProgressDTO = new PersonalStageProgressDTO();
        PersonalStageUser personalStageUser = personalStageUserDao.getById(personalStageUserId);
        if(personalStageUser == null){
            return personalStageProgressDTO;
        }
        Date startTime = personalStageUser.getCreateTime();
        GroupUserDTO groupUserDTO = wechatGroupConsr.getWxUserInfoByWxUserId(wxUserId);
        personalStageProgressDTO.setWxUserId(wxUserId);
        personalStageProgressDTO.setHeadPic(groupUserDTO.getHeadPic());
        personalStageProgressDTO.setNickName(groupUserDTO.getNickName());
        personalStageProgressDTO.setSex(groupUserDTO.getSex());
        personalStageProgressDTO.setRequireNumber(personalStageUser.getRequireNumber());
        personalStageProgressDTO.setScore(personalStageUser.getScore());
        List<PersonalStageProgressMessage> personalStageProgressMessages =
                personalStageProgressMessageDao.getPersonalProgress(startTime,progressId);
        Integer totalProgress = personalStageProgressMessageDao.countProgressMessage(progressId);
        personalStageProgressDTO.setTotalProgress(totalProgress == null ? 0 : totalProgress);
        if (!ListUtils.isEmpty(personalStageProgressMessages)){
            List<PersonalStageProgressMessage> newList = this.setProgressTime(personalStageProgressMessages,startTime);
            personalStageProgressDTO.setPersonalStageProgressMessageList(newList);
        }
        return personalStageProgressDTO;
    }

    @Override
    public void updateScore(AddScoreRequestVO vo) {
        personalStageUserDao.updateScore(vo.getPersonalStageUserId(), vo.getScore());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean isFirstVisit(Long personalStageUserId) {
        PersonalStageUser personalStageUser = personalStageUserDao.getById(personalStageUserId);
        if (null == personalStageUser){
            return true;
        }
        if (personalStageUser.getProgressStartTime() == null){
            personalStageUser.setProgressStartTime(new Date());
            personalStageUserDao.update(personalStageUser);
            return true;
        }
        return false;
    }

    @ParamLog("当前用户阶段")
    @Override
    public PersonalStage getCurrentPersonalStage(String wxId, String robotId) {
        PersonalStageUser last = personalStageUserDao.getLast(wxId, robotId, null);
        if (last!=null){
            return personalStageDao.getById(last.getPersonalStageId());
        }
        return null;
    }
    private List<PersonalStageProgressMessage> setProgressTime(List<PersonalStageProgressMessage> personalStageProgressMessages, Date startTime) {
        List<PersonalStageProgressMessage> newList = new ArrayList<>();
        Date now = new Date();
        for (PersonalStageProgressMessage message : personalStageProgressMessages){
            message.setProgressTime(DateUtils.addMinute(startTime,message.getMinutes()));
            if (message.getProgressTime().after(now)){
                break;
            }
            message.setState(1);
            newList.add(message);
        }
        //将最后一个进度设置为进行中
        newList.get(newList.size()-1).setState(0);
        return newList;
    }
}
