package com.pcloud.book.personalstage.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;


@ApiModel("定制化阶段用户")
@Data
public class PersonalStageUser extends BaseEntity {

    @ApiModelProperty("定制化阶段id")
    private Long personalStageId;

    @ApiModelProperty("微信用户id")
    private String wxId;

    @ApiModelProperty("小号id")
    private String robotId;

    @ApiModelProperty("机器人分类id")
    private Long robotClassifyId;

    @ApiModelProperty("状态：1正常，2唤醒，3熔断，4结束")
    private Integer state;

    @ApiModelProperty("用户非关键词发送次数")
    private Integer notKeywordSendCount;

    @ApiModelProperty("需求单号")
    private String requireNumber;

    @ApiModelProperty("进度值")
    private Integer score;

    @ApiModelProperty("进度开始时间")
    private Date progressStartTime;

    @ApiModelProperty("熔断回复次数")
    private Integer fusingReplyCount;

}