package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.WeixinQrcodeDao;
import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.dto.SyncWeixinGroupIdRequestDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.dto.WeixinQrcodeCountDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.book.group.entity.WeixinQrcode;
import com.pcloud.book.group.vo.QrStatisticsVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:22
 */
@Component("WeixinQrcodeDao")
public class WeixinQrcodeDaoImpl extends BaseDaoImpl<WeixinQrcode> implements WeixinQrcodeDao {
    @Override
    public WeixinQrcodeDTO getOneWechatGroup(Integer generation) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("generation", generation);
        return this.getSqlSession().selectOne(this.getStatement("getOneWechatGroup"),paramMap);
    }

    @Override
    public Long countWechatGroup() {
        return this.getSqlSession().selectOne(this.getStatement("countWechatGroup"));
    }

    @Override
    public Integer setIsUseById(Long id) {
        return this.getSqlSession().update(this.getStatement("setIsUseById"), id);
    }

    @Override
    public QrStatisticsVO getQrStatistics() {
        return this.getSqlSession().selectOne(this.getStatement("getQrStatistics"));
    }

    @Override
    public List<QrStatisticsVO> getQrStatisticsByVersion() {
        return this.getSessionTemplate().selectList(this.getStatement("getQrStatisticsByVersion"));
    }

    @Override
    public void updateStatusToError() {
        this.getSqlSession().update(this.getStatement("updateStatusToError"));
    }

    @Override
    public List<UpdateQrDTO> getInitialQr(int currentPage, Integer numPerPage) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("currentPage", currentPage);
        paramMap.put("numPerPage", numPerPage);
        return  this.getSqlSession().selectList(this.getStatement("getInitialQr"), paramMap);
    }

    @Override
    public void setOnUpdate(List<Long> qrIds) {
        this.getSqlSession().update(this.getStatement("setOnUpdate"), qrIds);
    }

    @Override
    public void updateQrUrl(UpdateQrDTO updateQrDTO) {
        this.getSqlSession().update(this.getStatement("updateQrUrl"), updateQrDTO);
    }


    @Override
    public Integer getQrOnHandleCount() {
        return this.getSqlSession().selectOne(this.getStatement("getQrOnHandleCount"));
    }

    @Override
    public List<UpdateQrDTO> getQrOnHandle(Integer currentPage, Integer numPerPage, List<Long> ids) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("currentPage", currentPage);
        paramMap.put("numPerPage", numPerPage);
        paramMap.put("ids", ids);
        return  this.getSqlSession().selectList(this.getStatement("getQrOnHandle"), paramMap);
    }

    @Override
    public void updateWeixinGroupId(Long weixinQrcodeId, String weixinGroupId) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("weixinQrcodeId", weixinQrcodeId);
        paramMap.put("weixinGroupId", weixinGroupId);
        this.getSqlSession().update(this.getStatement("updateWeixinGroupId"), paramMap);
    }

    @Override
    public List<SyncWeixinGroupIdRequestDTO> listNoIdQrcode(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStatement("listNoIdQrcode"), paramMap);
    }

    @Override
    public Map<Long, WeixinQrcodeCountDTO> listWeixinQrcodeCountByRobot(List<Long> robotIds) {
        return this.getSqlSession().selectMap(this.getStatement("listWeixinQrcodeCountByRobot"), robotIds, "robotId");
    }

    @Override
    public void updateUseState(Long id, Integer useState) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("useState", useState);
        paramMap.put("id", id);
        this.getSqlSession().update(this.getStatement("updateUseState"), paramMap);
    }

    @Override
    public Integer getQrcodeCount() {
        return this.getSqlSession().selectOne(this.getStatement("getQrcodeCount"));
    }

    @Override
    public List<QrStatisticsVO> getQrcodeCountByVersion() {
        return this.getSqlSession().selectList(this.getStatement("getQrcodeCountByVersion"));
    }

    @Override
    public Boolean checkExist(String weixinGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("checkExist"), weixinGroupId);
    }

    @Override
    public void updateState(Long weixinQrcodeId, Integer updateState) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("updateState", updateState);
        paramMap.put("weixinQrcodeId", weixinQrcodeId);
        this.getSqlSession().update(this.getStatement("updateState"), paramMap);
    }

    @Override
    public WeixinQrcode getByGroupId(String wechatGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getByGroupId"), wechatGroupId);
    }

    @Override
    public List<BookWxQrcodeDTO> listAvailableGroupByPage(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("listAvailableGroupByPage"), paramMap);
    }

    @Override
    public List<BookWxQrcodeDTO> listOver10AvailableGroupByPage(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("listOver10AvailableGroupByPage"), paramMap);
    }

    @Override
    public Map<String, BookWxQrcodeDTO> listByWxGroupIds(List<String> wxGroupIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wxGroupIds", wxGroupIds);
        return this.getSessionTemplate().selectMap(getStatement("listByWxGroupIds"), paramMap, "weixinGroupId");
    }

    @Override
    public String getVirtualIp(Integer generation) {
        return this.getSessionTemplate().selectOne("getVirtualIp", generation);
    }

    @Override
    public Integer countByState(Integer state, List<String> altIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("state", state);
        paramMap.put("altIds", altIds);
        return this.getSessionTemplate().selectOne("countByState", paramMap);
    }

    @Override
    public void updateGenerationMachineIp(Integer generation, String machineIp) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("generation", generation);
        paramMap.put("machineIp", machineIp);
        this.getSessionTemplate().update(getStatement("updateGenerationMachineIp"), paramMap);
    }

    @Override
    public List<UpdateQrDTO> listUpdateQrByGeneration(Integer generation, Integer limit) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("generation", generation);
        paramMap.put("num", limit);
        return this.getSessionTemplate().selectList(getStatement("listUpdateQrByGeneration"), paramMap);
    }

    @Override
    public Integer getCanUseCount(Integer version) {
        return this.getSessionTemplate().selectOne(getStatement("getCanUseCount"), version);
    }
}
