package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.dto.PcloudTdDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudClassifyTemplate;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api("全平台个人号配置")
@RestController("pcloudRobot")
@RequestMapping("pcloudRobotFacade")
public class PcloudRobotFacade {

    @Autowired
    private PcloudRobotBiz pcloudRobotBiz;

    @ApiOperation("新增全平台机器人")
    @PostMapping("/createPcloudRobot")
    ResponseDto<?> createPcloudRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全平台个人号") PcloudRobot pcloudRobot
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.createPcloudRobot(pcloudRobot);
        return new ResponseDto<>();
    }

    @ApiOperation("修改全平台机器人")
    @PostMapping("/updatePcloudRobot")
    ResponseDto<?> updatePcloudRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全平台个人号") PcloudRobot pcloudRobot
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.updatePcloudRobot(pcloudRobot);
        return new ResponseDto<>();
    }

    @ApiOperation("修改机器人状态")
    @GetMapping("/updateRobotState")
    ResponseDto<?> updateRobotState(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "id") @ApiParam("ID") Long id,
            @RequestParam(value = "state") @ApiParam("状态") Integer state
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.updateRobotState(id, state);
        return new ResponseDto<>();
    }

    @ApiOperation("获取全平台个人号列表")
    @GetMapping("/getPcloudRobotList")
    ResponseDto<?> getPcloudRobotList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "classifyId", required = false) @ApiParam("分类") Integer classifyId,
            @RequestParam(value = "nickName", required = false) @ApiParam("昵称") String nickName,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.getPcloudRobotList(classifyId, nickName,currentPage,numPerPage));
    }


    @ApiOperation("更新全平台个人号欢迎语")
    @PostMapping("/batchUpdatePcloudRobotWelcome")
    ResponseDto<?> batchUpdatePcloudRobotWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全平台个人号欢迎语列表") List<PcloudRobotWelcome> robotWelcomeList
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.batchUpdatePcloudRobotWelcome(robotWelcomeList);
        return new ResponseDto<>();
    }

    @ApiOperation("获取全平台个人号信息")
    @GetMapping("/getPcloudRobot")
    ResponseDto<?> getPcloudRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") Long id
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.getPcloudRobot(id));
    }

    @ApiOperation("小号关联关键词分类")
    @GetMapping("/relateKeywordClassify")
    ResponseDto<?> relateKeywordClassify(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "pcloudRobotId", required = false) @ApiParam("平台小号ID") Long pcloudRobotId,
            @RequestParam(value = "keywordClassifyId", required = false) @ApiParam("关键分类ID") Long keywordClassifyId
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.relateKeywordClassify(pcloudRobotId, keywordClassifyId);
        return new ResponseDto<>();
    }

    @ApiOperation("根据类型获取全平台个人号信息")
    @GetMapping("/getPcloudRobotByType")
    ResponseDto<?> getPcloudRobotByType(
            @RequestParam("robotType") Integer robotType
    ) throws BizException, PermissionException{
        return new ResponseDto<>(pcloudRobotBiz.getPcloudRobotByType(robotType));
    }

    @ApiOperation("获取全平台分类模板列表")
    @GetMapping("/listClassifyTemplate")
    ResponseDto<?> listClassifyTemplate(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "classifyId", required = false) @ApiParam("昵称") Integer classifyId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.listClassifyTemplate(classifyId,currentPage,numPerPage));
    }

    @ApiOperation("小号关联关键词分类")
    @GetMapping("/openTemplate")
    ResponseDto<?> openTemplate(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "classifyId", required = false) @ApiParam("分类ID") Integer classifyId,
            @RequestParam(value = "templateId", required = false) @ApiParam("模板ID") Long templateId
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.openTemplate(classifyId, templateId);
        return new ResponseDto<>();
    }

    @ApiOperation("上传分类模板语音")
    @PostMapping("/uploadTemplateAudio")
    ResponseDto<?> uploadTemplateAudio(
            @RequestHeader("token") @ApiParam("token信息") String token, @RequestBody PcloudClassifyTemplate classifyTemplate
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.uploadTemplateAudio(classifyTemplate);
        return new ResponseDto<>();
    }

    @ApiOperation("根据分类ID获取模板信息")
    @GetMapping("/getTemplateByClassifyId")
    ResponseDto<?> getTemplateByClassifyId(
            @RequestParam("classifyId") Integer classifyId
    ) throws BizException, PermissionException{
        return new ResponseDto<>(pcloudRobotBiz.getTemplateByClassifyId(classifyId));
    }

    @ApiOperation("修改平台退订")
    @PostMapping("/editPcloudTd")
    ResponseDto<?> editPcloudTd(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("全局退订") PcloudTdDTO pcloudTdDTO
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.editPcloudTd(pcloudTdDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取退订信息")
    @GetMapping("/getPcloudTdInfo")
    ResponseDto<?> getPcloudTd(
            @RequestHeader("token") @ApiParam("token信息") String token) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.getPcloudTdInfo());
    }

    @PostMapping("/handlePcloudTdReply")
    ResponseDto<?> handlePcloudTdReply(
            @RequestBody SendTextDTO sendTextDTO) throws BizException, PermissionException {
        pcloudRobotBiz.handlePcloudTdReply(sendTextDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("复制小号配置（欢迎语/引导语/群发/自动唤醒）")
    @GetMapping("/copyRobotConfiguration")
    ResponseDto<?> copyRobotConfiguration(
            @RequestParam(value = "sourceRobotWxId") @ApiParam("源小号wxid") String sourceRobotWxId,
            @RequestParam(value = "targetRobotWxId") @ApiParam("目的小号wxid") String targetRobotWxId
    ) throws BizException, PermissionException {
        pcloudRobotBiz.copyRobotConfiguration(sourceRobotWxId,targetRobotWxId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "根据小号分类获取小号列表")
    @GetMapping("/listSelfRobotByClassify")
    ResponseDto<?> listSelfRobotByClassify(
            @RequestHeader("token") String token,
            @RequestParam(value = "largeTemplet") Integer largeTemplet,
            @RequestParam(value = "classifyId", required = false) Long classifyId,
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.listSelfRobotByClassify(largeTemplet, classifyId, keyword, currentPage, numPerPage));
    }

    @ApiOperation("获取未分类的小号")
    @GetMapping("/listNoClassifyRobot")
    ResponseDto<?> listNoClassifyRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotBiz.listNoClassifyRobot(currentPage, numPerPage));
    }

    @ApiOperation("设置分类小号")
    @GetMapping("/setClassifyRobot")
    ResponseDto<?> setClassifyRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "wxId") @ApiParam("小号wxid") String wxId,
            @RequestParam(value = "classifyId") @ApiParam("分类ID") Integer classifyId) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.setClassifyRobot(wxId, classifyId);
        return new ResponseDto<>();
    }

    @ApiOperation("移除分类小号")
    @GetMapping("/removeClassifyRobot")
    ResponseDto<?> removeClassifyRobot(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "wxId") @ApiParam("小号wxid") String wxId,
            @RequestParam(value = "classifyId") @ApiParam("分类ID") Integer classifyId) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotBiz.removeClassifyRobot(wxId, classifyId);
        return new ResponseDto<>();
    }

}
