package com.pcloud.common.core.biz;

import com.pcloud.common.core.dto.FrontEventDto;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

/**
 * @author Shichunshan
 * @date: Created in 2018/4/17 11:09
 * @description:
 */
@Component("frontEventBiz")
public class FrontEventBizImpl implements FrontEventBiz{
    /**
     *
     */
    private final static Logger logger= LoggerFactory.getLogger(ConvertQueueBizImpl.class);

    @Autowired(required=false)
    @Qualifier("jmsFrontEventTemplate")
    private JmsTemplate jmsFrontEventTemplate;
    /**
     * 发送事件消息
     *
     * @param frontEventDto
     */
    @Override
    public void sendFrontEventQueue(FrontEventDto frontEventDto) throws BizException {
        MessageCreator messageCreator = new MessageCreator() {
            @Override
            public ObjectMessage createMessage(Session session) throws JMSException {
                return session.createObjectMessage(frontEventDto);
            }
        };
        try {
            jmsFrontEventTemplate.send(messageCreator);
        } catch (Exception e) {
            logger.error("发送失败，" + e.getMessage() + "," + frontEventDto, e);
            throw BizException.SEND_QUEUE_FAIL;
        }
        logger.info("发送成功，" + frontEventDto);
    }

    /**
     * 生成(事件ID/漏斗ID)前缀
     *
     * @param targetClass
     * @param targetType
     */
    public static String generatePrefix(String targetClass,String targetType){
        StringBuilder prefix = new StringBuilder();
        prefix.append(targetClass.toLowerCase()+"_");
        prefix.append(targetType.toLowerCase()+"_");
        return prefix.toString();
    }
}
