package com.pcloud.common.core.biz;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.dto.OperationLogDto;
import com.pcloud.common.exceptions.BizException;

@Service("operationLogQueueBiz")
public class OperationLogQueueBizImpl implements OperationLogQueueBiz {

	/**
	 * 
	 */
	private final static Logger logger = LoggerFactory.getLogger(OperationLogQueueBizImpl.class);
	
	/**
	 * 消息模板
	 */
	@Autowired(required = false)
	@Qualifier("jmsLogTemplate")
	private JmsTemplate jmsLogTemplate;

	@Override
	public void send(OperationLogDto operationLog) throws BizException {
		MessageCreator messageCreator = new MessageCreator() {
			@Override
			public ObjectMessage createMessage(Session session) throws JMSException {
				return session.createObjectMessage(operationLog);
			}
		};
		try {
			jmsLogTemplate.send(messageCreator);
		} catch (Exception e) {
			logger.error("发送失败，" + e.getMessage() + "," + operationLog, e);
			throw BizException.SEND_QUEUE_FAIL;
		}
		logger.info("发送成功，" + operationLog);
	}

}
