/**
 * 
 */
package com.pcloud.common.core.biz.impl;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.TranscodeQueueBiz;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.TranscodeMQDTO;
import com.pcloud.common.exceptions.BizException;

/**
 * 
 * 
 * @author：songx
 * @date：2018年5月17日,下午4:19:54
 */
@Service("transcodeQueueBiz")
public class TranscodeQueueBizImpl implements TranscodeQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 文件转码QUEUE
	 */
	@Override
	@ParamLog(description = "文件转码QUEUE")
	public void sendTranscodeQueue(TranscodeMQDTO transcodeMQDTO) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.TRANSCODE, transcodeMQDTO);
	}

}
