package com.pcloud.common.core.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @description 基金资源变更记录DTO
 * @author PENG
 * @date 2017年10月18日 下午2:04:16
 * @version 1.0
 */
public class FundMessageDto implements Serializable {

	private static final long serialVersionUID = -761187840913542109L;

	/**
	 * 出版标识
	 */
	private Long agentId;

	/**
	 * 操作目标编码
	 */
	private String targetCode;

	/**
	 * 操作目标ID
	 */
	private Long targetId;

	/**
	 * 操作人角色编码
	 */
	private String operatorCode;

	/**
	 * 操作人标识
	 */
	private Long operatorId;

	/**
	 * 操作编码
	 */
	private String operationCode;

	/**
	 * 操作描述
	 */
	private String operationDesc;

	/**
	 * 书刊ID
	 */
	private Long bookId;

	/**
	 * 操作时间
	 */
	private Date createdDate;

	/**
	 * 是否基金监控
	 */
	private Boolean isFund;

	/**
	 * 操作者IP地址
	 */
	private String ipAddress;

	public Long getAgentId() {
		return agentId;
	}

	public void setAgentId(Long agentId) {
		this.agentId = agentId;
	}

	public String getTargetCode() {
		return targetCode;
	}

	public void setTargetCode(String targetCode) {
		this.targetCode = targetCode;
	}

	public Long getTargetId() {
		return targetId;
	}

	public void setTargetId(Long targetId) {
		this.targetId = targetId;
	}

	public String getOperatorCode() {
		return operatorCode;
	}

	public void setOperatorCode(String operatorCode) {
		this.operatorCode = operatorCode;
	}

	public Long getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(Long operatorId) {
		this.operatorId = operatorId;
	}

	public String getOperationCode() {
		return operationCode;
	}

	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}

	public String getOperationDesc() {
		return operationDesc;
	}

	public void setOperationDesc(String operationDesc) {
		this.operationDesc = operationDesc;
	}

	public Long getBookId() {
		return bookId;
	}

	public void setBookId(Long bookId) {
		this.bookId = bookId;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Boolean getIsFund() {
		return isFund;
	}

	public void setIsFund(Boolean fund) {
		isFund = fund;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	@Override
	public String toString() {
		return "FundMessageDto{" + "agentId=" + agentId + ", targetCode='" + targetCode + '\'' + ", targetId="
				+ targetId + ", operatorCode='" + operatorCode + '\'' + ", operatorId=" + operatorId
				+ ", operationCode='" + operationCode + '\'' + ", operationDesc='" + operationDesc + '\'' + ", bookId="
				+ bookId + ", createdDate=" + createdDate + ", isFund=" + isFund + ", ipAddress='" + ipAddress + '\''
				+ '}';
	}
}
